<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dss="http://dss.esig.europa.eu/validation/simple-certificate-report">
                
	<xsl:output method="html" encoding="utf-8" indent="yes" omit-xml-declaration="yes" />
	
	<xsl:param name="rootTrustmarkUrlInTlBrowser">
		https://webgate.ec.europa.eu/tl-browser/#/trustmark/
	</xsl:param>
	<xsl:param name="rootCountryUrlInTlBrowser">
		https://webgate.ec.europa.eu/tl-browser/#/tl/
	</xsl:param>
	
   	<xsl:variable name="validationTime">
   		<xsl:value-of select="/dss:SimpleCertificateReport/@ValidationTime" />
   	</xsl:variable>

    <xsl:template match="/dss:SimpleCertificateReport">
		<xsl:comment>Generated by DSS v.5.7</xsl:comment>
	    
		<xsl:apply-templates select="dss:Chain"/>
    </xsl:template>
    
	<xsl:template match="dss:Chain">
    	<xsl:apply-templates/>
    </xsl:template>

    <xsl:template match="dss:ChainItem">
    
     	<xsl:variable name="indicationText" select="dss:Indication/text()"/>
        <xsl:variable name="indicationCssClass">
        	<xsl:choose>
				<xsl:when test="$indicationText='PASSED' or dss:trustAnchors">success</xsl:when>
				<xsl:when test="$indicationText='INDETERMINATE'">warning</xsl:when>
				<xsl:when test="$indicationText='FAILED'">danger</xsl:when>
				<!-- Cannot conclude (untrusted chain) -->
				<xsl:otherwise>default</xsl:otherwise>
			</xsl:choose>
        </xsl:variable>
    
		<div>
    		<xsl:attribute name="class">panel panel-<xsl:value-of select="$indicationCssClass" /></xsl:attribute>
    		<div>
    			<xsl:attribute name="class">panel-heading</xsl:attribute>
	    		<xsl:attribute name="data-target">#collapseCert-<xsl:value-of select="dss:id"/></xsl:attribute>
		       	<xsl:attribute name="data-toggle">collapse</xsl:attribute>
    			Certificate
	        </div>
    		<div>
    			<xsl:attribute name="class">panel-body collapse in</xsl:attribute>
	        	<xsl:attribute name="id">collapseCert-<xsl:value-of select="dss:id"/></xsl:attribute>
	        	
	        	<xsl:if test="dss:qualificationAtIssuance or dss:qualificationAtValidation">
		        	<dl>
			    		<xsl:attribute name="class">dl-horizontal</xsl:attribute>
			    		
			    		<dt>Qualification</dt>
			    		
			    		<dd>Issuance Time (<xsl:value-of select="dss:notBefore"/>) : 
			    			<span>
			    				<xsl:attribute name="class">label label-primary</xsl:attribute>
			    				
			    				<xsl:value-of select="dss:qualificationAtIssuance"/>
			    			</span>
			    		</dd>
			    		<dd>Validation Time (<xsl:value-of select="$validationTime"/>) : 
			    			<span>
			    				<xsl:attribute name="class">label label-primary</xsl:attribute>
			    				
			    				<xsl:value-of select="dss:qualificationAtValidation"/>
			    			</span>
			    		</dd>
		        	</dl>
	        	</xsl:if>
	        	
				<xsl:apply-templates select="dss:subject"/>
				
				<xsl:if test="dss:keyUsages or dss:extendedKeyUsages">
					<div>
						<xsl:attribute name="class">row</xsl:attribute>
						
						<div>
							<xsl:attribute name="class">col-md-6</xsl:attribute>
						
							<xsl:apply-templates select="dss:keyUsages"/>
						</div>
						<div>
							<xsl:attribute name="class">col-md-6</xsl:attribute>
						
							<xsl:apply-templates select="dss:extendedKeyUsages"/>
						</div>
					</div>
				</xsl:if>
					
	        	<dl>
	        		<xsl:attribute name="class">dl-horizontal</xsl:attribute>
	        		
	        		<dt>Validity</dt>
	        		<dd><xsl:value-of select="dss:notBefore"/> - <xsl:value-of select="dss:notAfter"/></dd>
	        		
	        		<xsl:if test="not(dss:trustAnchors)">
	       				<dt>Revocation</dt>
	       				<dd><xsl:apply-templates select="dss:revocation"/></dd>
       				</xsl:if>
	        		
					<xsl:apply-templates select="dss:ocspUrls"/>
					<xsl:apply-templates select="dss:crlUrls"/>
				</dl>
				
	        	<xsl:if test="dss:aiaUrls or dss:cpsUrls">
					<dl>
			    		<xsl:attribute name="class">dl-horizontal</xsl:attribute>
			    		
						<xsl:apply-templates select="dss:aiaUrls"/>
						<xsl:apply-templates select="dss:cpsUrls"/>
		        	</dl>
	        	</xsl:if>
				
	        	<xsl:if test="dss:trustAnchors">
					<dl>
			    		<xsl:attribute name="class">dl-horizontal</xsl:attribute>
			    		
						<xsl:apply-templates select="dss:trustAnchors"/>
		        	</dl>
	        	</xsl:if>
    		</div>
    	</div>
    </xsl:template>
    
    <xsl:template match="dss:subject">
     	<dl>
		    <xsl:attribute name="class">dl-horizontal</xsl:attribute>
	  		<xsl:if test="dss:commonName">
		   		<dt>Common name</dt>
		   		<dd><xsl:value-of select="dss:commonName"/></dd>
	  		</xsl:if>
	  		<xsl:if test="dss:givenName">
		   		<dt>Given name</dt>
		   		<dd><xsl:value-of select="dss:givenName"/></dd>
	  		</xsl:if>
	  		<xsl:if test="dss:surname">
		   		<dt>Surname</dt>
		   		<dd><xsl:value-of select="dss:surname"/></dd>
	  		</xsl:if>
	  		<xsl:if test="dss:pseudonym">
		   		<dt>Pseudonym</dt>
		   		<dd><xsl:value-of select="dss:pseudonym"/></dd>
	  		</xsl:if>
	  		<xsl:if test="dss:organizationName">
		   		<dt>Organization name</dt>
		   		<dd><xsl:value-of select="dss:organizationName"/></dd>
	  		</xsl:if>
	  		<xsl:if test="dss:organizationUnit">
		   		<dt>Organization Unit</dt>
		   		<dd><xsl:value-of select="dss:organizationUnit"/></dd>
	  		</xsl:if>
	  		<xsl:if test="dss:email">
		   		<dt>Email</dt>
		   		<dd><xsl:value-of select="dss:email"/></dd>
	  		</xsl:if>
	  		<xsl:if test="dss:locality">
		   		<dt>Locality</dt>
		   		<dd><xsl:value-of select="dss:locality"/></dd>
	  		</xsl:if>
	  		<xsl:if test="dss:state">
		   		<dt>State</dt>
		   		<dd><xsl:value-of select="dss:state"/></dd>
	  		</xsl:if>
	  		<xsl:if test="dss:country">
		   		<dt>Country</dt>
		   		<dd><xsl:value-of select="dss:country"/></dd>
	  		</xsl:if>
	  	</dl>
	</xsl:template>
	
	<xsl:template match="dss:keyUsages">
     	<dl>
		    <xsl:attribute name="class">dl-horizontal</xsl:attribute>
		    
		    <dt>Key usages</dt>
			<xsl:apply-templates select="dss:keyUsage"/>
		</dl>
	</xsl:template>
	
	<xsl:template match="dss:extendedKeyUsages">
     	<dl>
		    <xsl:attribute name="class">dl-horizontal</xsl:attribute>
		    
		    <dt>Extended key usages</dt>
			<xsl:apply-templates select="dss:extendedKeyUsage"/>
		</dl>
	</xsl:template>
	
    <xsl:template match="dss:revocation">
    	<xsl:choose>
			<xsl:when test="dss:revocationDate">
				<span>
					<xsl:attribute name="class">glyphicon glyphicon glyphicon-remove-sign text-danger</xsl:attribute>
					<xsl:attribute name="title">Revoked</xsl:attribute>
				</span>
     			Revoked (reason:<xsl:value-of select="dss:revocationReason" /> @ <xsl:value-of select="dss:revocationDate" />)
			</xsl:when>    	
			<xsl:when test="dss:productionDate">
      			<span>
					<xsl:attribute name="class">glyphicon glyphicon-ok-sign text-success</xsl:attribute>
					<xsl:attribute name="title">Not Revoked</xsl:attribute>
				</span>
			</xsl:when>
			<xsl:otherwise>
      			<span>
					<xsl:attribute name="class">glyphicon glyphicon-question-sign text-muted</xsl:attribute>
					<xsl:attribute name="title">No revocation data available</xsl:attribute>
				</span>
			</xsl:otherwise>
    	</xsl:choose>
    </xsl:template>
    
    <xsl:template match="dss:ocspUrls">
  		<dt>
  			<acronym>
  				<xsl:attribute name="title">Online Certificate Status Protocol</xsl:attribute>
  				OCSP
  			</acronym>
		</dt>
		<xsl:apply-templates select="dss:ocspUrl"/>
	</xsl:template>
	
  	<xsl:template match="dss:crlUrls">
  		<dt>
  			<acronym>
  				<xsl:attribute name="title">Certificate Revocation List</xsl:attribute>
		  		CRL
		  	</acronym>
		</dt>
		<xsl:apply-templates select="dss:crlUrl"/>
	</xsl:template>
	
	<xsl:template match="dss:aiaUrls">
  		<dt>
  			<acronym>
  				<xsl:attribute name="title">Authority Information Access</xsl:attribute>
  		  		AIA
  		  	</acronym>
		</dt>
		<xsl:apply-templates select="dss:aiaUrl"/>
	</xsl:template>
	
    <xsl:template match="dss:cpsUrls">
  		<dt>
  			<acronym>
  				<xsl:attribute name="title">Certification Practice Statements</xsl:attribute>
  		  		CPS
  		  	</acronym>
		</dt>
		<xsl:apply-templates select="dss:cpsUrl"/>
	</xsl:template>
	
    <xsl:template match="dss:trustAnchors">
  		<dt>
  			Trust Anchor
		</dt>
		<xsl:apply-templates select="dss:trustAnchor"/>
	</xsl:template>
    
    <xsl:template match="dss:trustAnchor">
    	<dd>
    		<a>
    			<xsl:attribute name="href">
	    			<xsl:value-of select="concat($rootCountryUrlInTlBrowser, dss:countryCode)" />
	    		</xsl:attribute>
	    		<xsl:attribute name="target">_blank</xsl:attribute>
	    		<xsl:attribute name="title"><xsl:value-of select="dss:countryCode" /></xsl:attribute>
	    		
	    		<span>
	    			<xsl:attribute name="class">
		    			small_flag <xsl:value-of select="concat('flag_', dss:countryCode)" />
		    		</xsl:attribute>
	    		</span>
    		</a>
    		
    		<span>
    			<xsl:attribute name="class">glyphicon glyphicon-arrow-right dss-arrow</xsl:attribute>
    		</span>
    		
    		<a>
	    		<xsl:attribute name="href">
	    			<xsl:value-of select="concat($rootTrustmarkUrlInTlBrowser, dss:countryCode, '/', dss:trustServiceProviderRegistrationId)" />
	    		</xsl:attribute>
	    		<xsl:attribute name="target">_blank</xsl:attribute>
	    		<xsl:attribute name="title">View in TL Browser</xsl:attribute>
	    		
	    		<xsl:value-of select="dss:trustServiceProvider" /> 
    		</a>
    		
    		<span>
    			<xsl:attribute name="class">glyphicon glyphicon-arrow-right dss-arrow</xsl:attribute>
    		</span>
    		
    		<xsl:value-of select="dss:trustServiceName" />
    	</dd>
    </xsl:template>
    
    <xsl:template match="dss:keyUsage | dss:extendedKeyUsage">
    	<dd><xsl:value-of select="." /></dd>
    </xsl:template>
    
    <xsl:template match="dss:ocspUrl | dss:crlUrl | dss:aiaUrl | dss:cpsUrl | dss:pdsUrl">
    	<dd>
    		<a>
    			<xsl:attribute name="href"><xsl:value-of select="." /></xsl:attribute>
	    		<xsl:attribute name="target">_blank</xsl:attribute>
	    		
    			<xsl:value-of select="." />
    		</a>
    	</dd>
    </xsl:template>

</xsl:stylesheet>
