/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.xades.XAdESSignatureUtils;
import eu.europa.esig.dss.xades.definition.SAMLAssertionNamespace;
import eu.europa.esig.dss.xades.definition.XAdESNamespaces;
import eu.europa.esig.dss.xades.definition.XAdESPaths;
import eu.europa.esig.dss.xades.definition.xades111.XAdES111Paths;
import eu.europa.esig.dss.xades.definition.xades122.XAdES122Paths;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Paths;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xades.validation.scope.XAdESSignatureScopeFinder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDocumentValidator
extends SignedDocumentValidator {
    private static final byte[] xmlPreamble = new byte[]{60};
    private static final byte[] xmlWithBomPreample = new byte[]{-17, -69, -65, 60};
    protected List<XAdESPaths> xadesPathsHolders;
    protected Document rootElement;
    private boolean disableXSWProtection = false;
    private List<AdvancedSignature> signatures;

    XMLDocumentValidator() {
    }

    public XMLDocumentValidator(DSSDocument dssDocument) {
        super(new XAdESSignatureScopeFinder());
        this.document = dssDocument;
        this.rootElement = DomUtils.buildDOM(dssDocument);
        this.xadesPathsHolders = new ArrayList<XAdESPaths>();
        this.xadesPathsHolders.add(new XAdES111Paths());
        this.xadesPathsHolders.add(new XAdES122Paths());
        this.xadesPathsHolders.add(new XAdES132Paths());
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        return DSSUtils.compareFirstBytes(dssDocument, xmlPreamble) || DSSUtils.compareFirstBytes(dssDocument, xmlWithBomPreample);
    }

    public void setDisableXSWProtection(boolean disableXSWProtection) {
        this.disableXSWProtection = disableXSWProtection;
    }

    @Override
    public List<AdvancedSignature> getSignatures() {
        if (this.signatures != null) {
            return this.signatures;
        }
        this.signatures = new ArrayList<AdvancedSignature>();
        NodeList signatureNodeList = DomUtils.getNodeList(this.rootElement, XAdES132Paths.ALL_SIGNATURE_WITH_NO_COUNTERSIGNATURE_AS_PARENT_PATH);
        for (int ii = 0; ii < signatureNodeList.getLength(); ++ii) {
            Element signatureEl = (Element)signatureNodeList.item(ii);
            Node parent = signatureEl.getParentNode();
            String nodeName = parent.getNodeName();
            String ns = parent.getNamespaceURI();
            if ("saml2:Assertion".equals(nodeName) && SAMLAssertionNamespace.NS.isSameUri(ns)) continue;
            XAdESSignature xadesSignature = new XAdESSignature(signatureEl, this.xadesPathsHolders);
            xadesSignature.setSignatureFilename(this.document.getName());
            xadesSignature.setDetachedContents(this.detachedContents);
            xadesSignature.setContainerContents(this.containerContents);
            xadesSignature.setProvidedSigningCertificateToken(this.providedSigningCertificateToken);
            xadesSignature.setDisableXSWProtection(this.disableXSWProtection);
            xadesSignature.prepareOfflineCertificateVerifier(this.certificateVerifier);
            this.signatures.add(xadesSignature);
        }
        return this.signatures;
    }

    public AdvancedSignature getSignatureById(String signatureId) throws DSSException {
        Objects.requireNonNull(signatureId, "Signature Id cannot be null");
        List<AdvancedSignature> advancedSignatures = this.getSignatures();
        for (AdvancedSignature advancedSignature : advancedSignatures) {
            String advancedSignatureId = advancedSignature.getId();
            if (!signatureId.equals(advancedSignatureId)) continue;
            return advancedSignature;
        }
        throw new DSSException("The signature with the given id was not found!");
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(String signatureId) {
        List<DSSDocument> result;
        block1: {
            AdvancedSignature advancedSignature;
            Objects.requireNonNull(signatureId, "Signature Id cannot be null");
            List<AdvancedSignature> signatureList = this.getSignatures();
            result = this.getOriginalDocumentsFromListOfSignatures(signatureList, signatureId);
            if (!Utils.isCollectionEmpty(result)) break block1;
            Iterator<AdvancedSignature> iterator = signatureList.iterator();
            while (iterator.hasNext() && !Utils.isCollectionNotEmpty(result = this.getOriginalDocumentsFromListOfSignatures((advancedSignature = iterator.next()).getCounterSignatures(), signatureId))) {
            }
        }
        return result;
    }

    private List<DSSDocument> getOriginalDocumentsFromListOfSignatures(List<AdvancedSignature> signatureList, String signatureId) {
        for (AdvancedSignature advancedSignature : signatureList) {
            if (!signatureId.equals(advancedSignature.getId())) continue;
            return this.getOriginalDocuments(advancedSignature);
        }
        return Collections.emptyList();
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        XAdESSignature signature = (XAdESSignature)advancedSignature;
        return XAdESSignatureUtils.getSignerDocuments(signature);
    }

    public List<XAdESPaths> getXAdESPathsHolder() {
        return this.xadesPathsHolders;
    }

    public void addXAdESPathsHolder(XAdESPaths xadesPathsHolder) {
        this.xadesPathsHolders.add(xadesPathsHolder);
    }

    public void clearQueryHolders() {
        this.xadesPathsHolders.clear();
    }

    public Document getRootElement() {
        return this.rootElement;
    }

    static {
        XAdESNamespaces.registerNamespaces();
        DomUtils.registerNamespace(SAMLAssertionNamespace.NS);
    }
}

