/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.XAdESTimestampParameters;
import eu.europa.esig.dss.xades.signature.XAdESLevelC;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESLevelX
extends XAdESLevelC {
    public XAdESLevelX(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatureTag() throws DSSException {
        super.extendSignatureTag();
        Element levelCUnsignedProperties = (Element)this.unsignedSignaturePropertiesDom.cloneNode(true);
        SignatureLevel signatureLevel = this.params.getSignatureLevel();
        if (!this.xadesSignature.hasXProfile() || SignatureLevel.XAdES_X.equals((Object)signatureLevel) || SignatureLevel.XAdES_XL.equals((Object)signatureLevel)) {
            if (SignatureLevel.XAdES_XL.equals((Object)this.params.getSignatureLevel())) {
                NodeList toRemoveList = this.xadesSignature.getSigAndRefsTimeStamp();
                for (int index = 0; index < toRemoveList.getLength(); ++index) {
                    Node item = toRemoveList.item(index);
                    this.removeChild(this.unsignedSignaturePropertiesDom, item);
                }
            }
            XAdESTimestampParameters signatureTimestampParameters = this.params.getSignatureTimestampParameters();
            String canonicalizationMethod = signatureTimestampParameters.getCanonicalizationMethod();
            byte[] timestampX1Data = this.xadesSignature.getTimestampSource().getTimestampX1Data(canonicalizationMethod);
            DigestAlgorithm timestampDigestAlgorithm = signatureTimestampParameters.getDigestAlgorithm();
            byte[] digestValue = DSSUtils.digest(timestampDigestAlgorithm, timestampX1Data);
            this.createXAdESTimeStampType(TimestampType.VALIDATION_DATA_TIMESTAMP, canonicalizationMethod, digestValue);
            this.unsignedSignaturePropertiesDom = this.indentIfPrettyPrint(this.unsignedSignaturePropertiesDom, levelCUnsignedProperties);
        }
    }
}

