/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.signature;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.reference.CanonicalizationTransform;
import eu.europa.esig.dss.xades.reference.DSSReference;
import eu.europa.esig.dss.xades.reference.DSSTransform;
import eu.europa.esig.dss.xades.reference.XPath2FilterEnvelopedSignatureTransform;
import eu.europa.esig.dss.xades.signature.XAdESSignatureBuilder;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class EnvelopedSignatureBuilder
extends XAdESSignatureBuilder {
    public EnvelopedSignatureBuilder(XAdESSignatureParameters params, DSSDocument origDoc, CertificateVerifier certificateVerifier) {
        super(params, origDoc, certificateVerifier);
    }

    @Override
    protected Document buildRootDocumentDom() {
        return DomUtils.buildDOM(this.detachedDocument);
    }

    @Override
    protected Node getParentNodeOfSignature() {
        String xPathLocationString = this.params.getXPathLocationString();
        if (Utils.isStringNotEmpty(xPathLocationString)) {
            return DomUtils.getElement(this.documentDom, xPathLocationString);
        }
        return this.documentDom.getDocumentElement();
    }

    @Override
    protected void incorporateSignatureDom(Node parentNodeOfSignature) {
        if (this.params.getXPathElementPlacement() == null || Utils.isStringEmpty(this.params.getXPathLocationString())) {
            parentNodeOfSignature.appendChild(this.signatureDom);
            return;
        }
        switch (this.params.getXPathElementPlacement()) {
            case XPathAfter: {
                if (parentNodeOfSignature.isEqualNode(this.documentDom.getDocumentElement())) {
                    parentNodeOfSignature.appendChild(this.signatureDom);
                    break;
                }
                Node parent = parentNodeOfSignature.getParentNode();
                parent.insertBefore(this.signatureDom, parentNodeOfSignature.getNextSibling());
                break;
            }
            case XPathFirstChildOf: {
                parentNodeOfSignature.insertBefore(this.signatureDom, parentNodeOfSignature.getFirstChild());
                break;
            }
            default: {
                parentNodeOfSignature.appendChild(this.signatureDom);
            }
        }
    }

    @Override
    protected DSSReference createReference(DSSDocument document, int referenceIndex) {
        DSSReference dssReference = new DSSReference();
        dssReference.setId("r-" + this.deterministicId + "-" + referenceIndex);
        dssReference.setUri("");
        dssReference.setContents(document);
        DigestAlgorithm digestAlgorithm = this.getReferenceDigestAlgorithmOrDefault(this.params);
        dssReference.setDigestMethodAlgorithm(digestAlgorithm);
        ArrayList<DSSTransform> dssTransformList = new ArrayList<DSSTransform>();
        XPath2FilterEnvelopedSignatureTransform xPath2FilterTransform = new XPath2FilterEnvelopedSignatureTransform(this.getXmldsigNamespace());
        dssTransformList.add(xPath2FilterTransform);
        CanonicalizationTransform canonicalizationTransform = new CanonicalizationTransform(this.getXmldsigNamespace(), "http://www.w3.org/2001/10/xml-exc-c14n#");
        dssTransformList.add(canonicalizationTransform);
        dssReference.setTransforms(dssTransformList);
        return dssReference;
    }

    @Override
    protected DSSDocument transformReference(DSSReference reference) {
        DSSDocument dssDocument = reference.getContents();
        Node nodeToTransform = null;
        String uri = reference.getUri();
        if (Utils.isStringNotBlank(uri) && uri.startsWith("#") && !EnvelopedSignatureBuilder.isXPointer(uri)) {
            Document document = DomUtils.buildDOM(dssDocument);
            DSSXMLUtils.recursiveIdBrowse(document.getDocumentElement());
            String targetId = DomUtils.getId(uri);
            nodeToTransform = document.getElementById(targetId);
        }
        if (Utils.isCollectionEmpty(reference.getTransforms())) {
            if (nodeToTransform == null) {
                return dssDocument;
            }
            byte[] nodeBytes = DSSXMLUtils.getNodeBytes(nodeToTransform);
            return new InMemoryDocument(nodeBytes);
        }
        if (nodeToTransform == null) {
            nodeToTransform = DomUtils.buildDOM(dssDocument);
        }
        byte[] transformedReferenceBytes = this.applyTransformations(reference, nodeToTransform);
        return new InMemoryDocument(transformedReferenceBytes);
    }

    private static boolean isXPointer(String uri) {
        boolean xPointer = uri.startsWith("#xpointer(") || uri.startsWith("#xmlns(");
        return xPointer;
    }
}

