/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.definition.DSSNamespace;
import eu.europa.esig.dss.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.xades.definition.XAdESNamespaces;
import eu.europa.esig.dss.xades.reference.ComplexTransform;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XPathTransform
extends ComplexTransform {
    protected final String xPathExpression;

    public XPathTransform(String xPathExpression) {
        this(XAdESNamespaces.XMLDSIG, "http://www.w3.org/TR/1999/REC-xpath-19991116", xPathExpression);
    }

    public XPathTransform(DSSNamespace xmlDSigNamespace, String xPathExpression) {
        this(xmlDSigNamespace, "http://www.w3.org/TR/1999/REC-xpath-19991116", xPathExpression);
    }

    protected XPathTransform(DSSNamespace xmlDSigNamespace, String algorithm, String xPathExpression) {
        super(xmlDSigNamespace, algorithm);
        Objects.requireNonNull(xPathExpression, "xPathExpression cannot be null!");
        this.xPathExpression = xPathExpression;
    }

    @Override
    public Element createTransform(Document document, Element parentNode) {
        Element transform = super.createTransform(document, parentNode);
        return DomUtils.addTextElement(document, transform, this.namespace, XMLDSigElement.XPATH, this.xPathExpression);
    }
}

