/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalData;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.PastSignatureValidation;
import java.util.Date;
import java.util.Map;

public class PastSignatureValidationCheck
extends ChainItem<XmlValidationProcessArchivalData> {
    private final SignatureWrapper signature;
    private final Map<String, XmlBasicBuildingBlocks> bbbs;
    private final POEExtraction poe;
    private final Date currentTime;
    private final ValidationPolicy policy;
    private final Context context;
    private Indication indication;
    private SubIndication subIndication;

    public PastSignatureValidationCheck(I18nProvider i18nProvider, XmlValidationProcessArchivalData result, SignatureWrapper signature, Map<String, XmlBasicBuildingBlocks> bbbs, POEExtraction poe, Date currentTime, ValidationPolicy policy, Context context, LevelConstraint constraint) {
        super(i18nProvider, result, constraint, signature.getId());
        this.signature = signature;
        this.bbbs = bbbs;
        this.poe = poe;
        this.currentTime = currentTime;
        this.policy = policy;
        this.context = context;
    }

    @Override
    protected boolean process() {
        XmlBasicBuildingBlocks tokenBBB = this.bbbs.get(this.signature.getId());
        PastSignatureValidation psv = new PastSignatureValidation(this.i18nProvider, this.signature, this.bbbs, this.poe, this.currentTime, this.policy, this.context);
        XmlPSV psvResult = (XmlPSV)psv.execute();
        tokenBBB.setPSV(psvResult);
        tokenBBB.setConclusion(psvResult.getConclusion());
        if (this.isValid(psvResult)) {
            return true;
        }
        this.indication = psvResult.getConclusion().getIndication();
        this.subIndication = psvResult.getConclusion().getSubIndication();
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.PSV_IPSVC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.PSV_IPSVC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.indication;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.subIndication;
    }
}

