/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfltvd.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessLongTermData;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.List;

public class AcceptableBasicSignatureValidationCheck
extends ChainItem<XmlValidationProcessLongTermData> {
    private final XmlConstraintsConclusion basicSignatureValidation;
    private Indication bbbIndication;
    private SubIndication bbbSubIndication;
    private List<XmlName> bbbErrors;

    public AcceptableBasicSignatureValidationCheck(I18nProvider i18nProvider, XmlValidationProcessLongTermData result, XmlConstraintsConclusion basicSignatureValidation, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.basicSignatureValidation = basicSignatureValidation;
    }

    @Override
    protected boolean process() {
        if (this.basicSignatureValidation != null && this.basicSignatureValidation.getConclusion() != null) {
            XmlConclusion basicSignatureConclusion = this.basicSignatureValidation.getConclusion();
            this.bbbIndication = basicSignatureConclusion.getIndication();
            this.bbbSubIndication = basicSignatureConclusion.getSubIndication();
            this.bbbErrors = basicSignatureConclusion.getErrors();
            return ValidationProcessUtils.isAllowedBasicSignatureValidation(basicSignatureConclusion);
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.LTV_ABSV;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.LTV_ABSV_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.bbbIndication;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.bbbSubIndication;
    }

    @Override
    protected List<XmlName> getPreviousErrors() {
        return this.bbbErrors;
    }
}

