/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.trust.filter;

import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.enumerations.CertificateQualification;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.qualification.certificate.CertificateQualificationCalculation;
import eu.europa.esig.dss.validation.process.qualification.trust.filter.TrustedServiceFilter;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueServiceFilter
implements TrustedServiceFilter {
    private static final Logger LOG = LoggerFactory.getLogger(UniqueServiceFilter.class);
    private final CertificateWrapper endEntityCert;

    public UniqueServiceFilter(CertificateWrapper endEntityCert) {
        this.endEntityCert = endEntityCert;
    }

    @Override
    public List<TrustedServiceWrapper> filter(List<TrustedServiceWrapper> trustServices) {
        TrustedServiceWrapper selectedTrustedService = null;
        if (Utils.collectionSize(trustServices) == 1) {
            selectedTrustedService = trustServices.get(0);
        } else if (Utils.isCollectionNotEmpty(trustServices)) {
            LOG.info("More than one selected trust services");
            EnumMap<CertificateQualification, List<String>> qualificationResults = new EnumMap<CertificateQualification, List<String>>(CertificateQualification.class);
            for (TrustedServiceWrapper trustService : trustServices) {
                CertificateQualificationCalculation calculator = new CertificateQualificationCalculation(this.endEntityCert, trustService);
                CertificateQualification certQualification = calculator.getQualification();
                if (qualificationResults.containsKey((Object)certQualification)) continue;
                qualificationResults.put(certQualification, trustService.getServiceNames());
            }
            if (qualificationResults.size() > 1) {
                LOG.warn("Unable to select the trust service ! Several possible conclusions {}", (Object)qualificationResults);
            } else {
                LOG.info("All trust services conclude with the same result");
                selectedTrustedService = trustServices.get(0);
            }
        }
        if (selectedTrustedService != null) {
            return Collections.singletonList(selectedTrustedService);
        }
        return Collections.emptyList();
    }
}

