/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.xcv.rfc.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlRFC;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import java.util.Date;

public abstract class AbstractRevocationFreshCheck
extends ChainItem<XmlRFC> {
    protected final RevocationWrapper revocationData;
    private final Date validationDate;

    protected AbstractRevocationFreshCheck(I18nProvider i18nProvider, XmlRFC result, RevocationWrapper revocationData, Date validationDate, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.revocationData = revocationData;
        this.validationDate = validationDate;
    }

    protected boolean isProductionDateAfterValidationTime() {
        long maxFreshness = this.getMaxFreshness();
        long validationDateTime = this.validationDate.getTime();
        long limit = validationDateTime - maxFreshness;
        Date productionDate = this.revocationData.getProductionDate();
        return productionDate != null && productionDate.after(new Date(limit));
    }

    protected abstract long getMaxFreshness();

    @Override
    protected MessageTag getAdditionalInfo() {
        String productionTimeString = "not defined";
        String nextUpdateString = "not defined";
        if (this.revocationData != null) {
            if (this.revocationData.getProductionDate() != null) {
                productionTimeString = ValidationProcessUtils.getFormattedDate(this.revocationData.getProductionDate());
            }
            if (this.revocationData.getNextUpdate() != null) {
                nextUpdateString = ValidationProcessUtils.getFormattedDate(this.revocationData.getNextUpdate());
            }
        }
        Object[] params = new Object[]{ValidationProcessUtils.getFormattedDate(this.validationDate), productionTimeString, nextUpdateString};
        return MessageTag.REVOCATION_CHECK.setArgs(params);
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.BBB_RFC_IRIF;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.BBB_RFC_IRIF_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.INDETERMINATE;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return SubIndication.TRY_LATER;
    }
}

