/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav;

import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.DigestCryptographicCheck;
import java.util.Date;

public class DigestAlgorithmAcceptanceValidation
extends Chain<XmlSAV> {
    protected final DigestAlgorithm digestAlgorithm;
    protected final Date currentTime;
    protected final Context context;
    protected final ValidationPolicy validationPolicy;

    public DigestAlgorithmAcceptanceValidation(I18nProvider i18nProvider, Date currentTime, DigestAlgorithm digestAlgorithm, ValidationPolicy validationPolicy, Context context) {
        super(i18nProvider, new XmlSAV());
        this.digestAlgorithm = digestAlgorithm;
        this.currentTime = currentTime;
        this.validationPolicy = validationPolicy;
        this.context = context;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.DAAV;
    }

    @Override
    protected void initChain() {
        this.firstItem = this.digestCryptographic();
    }

    protected ChainItem<XmlSAV> digestCryptographic() {
        CryptographicConstraint constraint = this.validationPolicy.getSignatureCryptographicConstraint(this.context);
        return new DigestCryptographicCheck(this.i18nProvider, (XmlSAV)this.result, this.digestAlgorithm, this.currentTime, constraint);
    }
}

