/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.executor;

import eu.europa.esig.dss.detailedreport.DetailedReport;
import eu.europa.esig.dss.diagnostic.DiagnosticData;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.simplereport.jaxb.XmlSimpleReport;
import eu.europa.esig.dss.simplereport.jaxb.XmlValidationPolicy;
import java.util.Date;

public abstract class AbstractSimpleReportBuilder {
    private final Date currentTime;
    private final ValidationPolicy policy;
    protected final DiagnosticData diagnosticData;
    protected final DetailedReport detailedReport;

    public AbstractSimpleReportBuilder(Date currentTime, ValidationPolicy policy, DiagnosticData diagnosticData, DetailedReport detailedReport) {
        this.currentTime = currentTime;
        this.policy = policy;
        this.diagnosticData = diagnosticData;
        this.detailedReport = detailedReport;
    }

    public XmlSimpleReport build() {
        XmlSimpleReport simpleReport = new XmlSimpleReport();
        this.addPolicyNode(simpleReport);
        this.addValidationTime(simpleReport);
        this.addDocumentName(simpleReport);
        boolean containerInfoPresent = this.diagnosticData.isContainerInfoPresent();
        if (containerInfoPresent) {
            this.addContainerType(simpleReport);
        }
        return simpleReport;
    }

    private void addPolicyNode(XmlSimpleReport report) {
        XmlValidationPolicy xmlpolicy = new XmlValidationPolicy();
        xmlpolicy.setPolicyName(this.policy.getPolicyName());
        xmlpolicy.setPolicyDescription(this.policy.getPolicyDescription());
        report.setValidationPolicy(xmlpolicy);
    }

    private void addValidationTime(XmlSimpleReport report) {
        report.setValidationTime(this.currentTime);
    }

    private void addDocumentName(XmlSimpleReport report) {
        report.setDocumentName(this.diagnosticData.getDocumentName());
    }

    private void addContainerType(XmlSimpleReport simpleReport) {
        simpleReport.setContainerType(this.diagnosticData.getContainerType());
    }
}

