/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.identifier.EntityIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.ValidationDataForInclusion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationDataForInclusionBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationDataForInclusionBuilder.class);
    private final ValidationContext validationContext;
    private final ListCertificateSource completeCertificateSource;
    private Collection<CertificateToken> excludeCertificateTokens;
    private Collection<EncapsulatedRevocationTokenIdentifier> excludeCRLs;
    private Collection<EncapsulatedRevocationTokenIdentifier> excludeOCSPs;

    public ValidationDataForInclusionBuilder(ValidationContext validationContext, ListCertificateSource completeCertificateSource) {
        this.validationContext = validationContext;
        this.completeCertificateSource = completeCertificateSource;
    }

    public ValidationDataForInclusionBuilder excludeCertificateTokens(Collection<CertificateToken> excludeCertificateTokens) {
        this.excludeCertificateTokens = excludeCertificateTokens;
        return this;
    }

    public ValidationDataForInclusionBuilder excludeCRLs(Collection<EncapsulatedRevocationTokenIdentifier> excludeCRLs) {
        this.excludeCRLs = excludeCRLs;
        return this;
    }

    public ValidationDataForInclusionBuilder excludeOCSPs(Collection<EncapsulatedRevocationTokenIdentifier> excludeOCSPs) {
        this.excludeOCSPs = excludeOCSPs;
        return this;
    }

    public ValidationDataForInclusion build() {
        ValidationDataForInclusion validationDataForInclusion = new ValidationDataForInclusion();
        Set<CertificateToken> validationCertificates = this.getValidationCertificates();
        validationDataForInclusion.setCrlTokens(this.getCRLsForInclusion(validationCertificates));
        validationDataForInclusion.setOcspTokens(this.getOCSPsForInclusion(validationCertificates));
        validationDataForInclusion.setCertificateTokens(this.getCertificatesForInclusion(validationCertificates));
        return validationDataForInclusion;
    }

    private Set<CertificateToken> getValidationCertificates() {
        Set<CertificateToken> certificatesForInclusion = this.completeCertificateSource.getAllCertificateTokens();
        List<EntityIdentifier> publicKeys = this.getEntityIdentifierList(certificatesForInclusion);
        for (CertificateToken certificateToken : this.validationContext.getProcessedCertificates()) {
            if (!publicKeys.contains(certificateToken.getEntityKey())) {
                certificatesForInclusion.add(certificateToken);
                publicKeys.add(certificateToken.getEntityKey());
                continue;
            }
            LOG.debug("Certificate Token with Id : [{}] has not been added for inclusion. The same public key is already present!", (Object)certificateToken.getDSSIdAsString());
        }
        return certificatesForInclusion;
    }

    private List<EntityIdentifier> getEntityIdentifierList(Collection<CertificateToken> certificateTokens) {
        ArrayList<EntityIdentifier> entityIdentifiers = new ArrayList<EntityIdentifier>();
        for (CertificateToken certificateToken : certificateTokens) {
            entityIdentifiers.add(certificateToken.getEntityKey());
        }
        return entityIdentifiers;
    }

    private Set<CertificateToken> getCertificatesForInclusion(Set<CertificateToken> validationCertificates) {
        if (Utils.isCollectionNotEmpty(this.excludeCertificateTokens)) {
            validationCertificates.removeAll(this.excludeCertificateTokens);
        }
        return validationCertificates;
    }

    private List<CRLToken> getCRLsForInclusion(Set<CertificateToken> validationCertificates) {
        ArrayList<CRLToken> crlTokens = new ArrayList<CRLToken>();
        List<Object> revocationIds = new ArrayList();
        if (Utils.isCollectionNotEmpty(this.excludeCRLs)) {
            revocationIds = this.excludeCRLs.stream().map(r -> r.asXmlId()).collect(Collectors.toList());
        }
        for (RevocationToken<Revocation> revocationToken : this.validationContext.getProcessedRevocations()) {
            if (!(revocationToken instanceof CRLToken) || revocationIds.contains(revocationToken.getDSSId().asXmlId()) || !this.isAtLeastOneCertificateCovered(revocationToken, validationCertificates)) continue;
            CRLToken crlToken = (CRLToken)revocationToken;
            revocationIds.add(crlToken.getDSSId().asXmlId());
            crlTokens.add(crlToken);
        }
        return crlTokens;
    }

    private List<OCSPToken> getOCSPsForInclusion(Set<CertificateToken> validationCertificates) {
        ArrayList<OCSPToken> ocspTokens = new ArrayList<OCSPToken>();
        List<Object> revocationIds = new ArrayList();
        if (Utils.isCollectionNotEmpty(this.excludeOCSPs)) {
            revocationIds = this.excludeOCSPs.stream().map(r -> r.asXmlId()).collect(Collectors.toList());
        }
        for (RevocationToken<Revocation> revocationToken : this.validationContext.getProcessedRevocations()) {
            if (!(revocationToken instanceof OCSPToken) || revocationIds.contains(revocationToken.getDSSId().asXmlId()) || !this.isAtLeastOneCertificateCovered(revocationToken, validationCertificates)) continue;
            OCSPToken ocspToken = (OCSPToken)revocationToken;
            revocationIds.add(ocspToken.getDSSId().asXmlId());
            ocspTokens.add(ocspToken);
        }
        return ocspTokens;
    }

    private boolean isAtLeastOneCertificateCovered(RevocationToken revocationToken, Collection<CertificateToken> certificateTokens) {
        String relatedCertificateID = revocationToken.getRelatedCertificateID();
        if (Utils.isStringNotEmpty(relatedCertificateID)) {
            for (CertificateToken certificateToken : certificateTokens) {
                if (!certificateToken.getDSSIdAsString().equals(relatedCertificateID)) continue;
                return true;
            }
        }
        return false;
    }
}

