/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPAndCRLRevocationSource
implements RevocationSource<Revocation> {
    private static final long serialVersionUID = 3205352844337899410L;
    private static final Logger LOG = LoggerFactory.getLogger(OCSPAndCRLRevocationSource.class);
    private final RevocationSource<OCSP> ocspSource;
    private final RevocationSource<CRL> crlSource;

    public OCSPAndCRLRevocationSource(RevocationSource<CRL> crlSource, RevocationSource<OCSP> ocspSource) {
        this.crlSource = crlSource;
        this.ocspSource = ocspSource;
    }

    @Override
    public RevocationToken<Revocation> getRevocationToken(CertificateToken certificateToken, CertificateToken issuerToken) {
        RevocationToken<Revocation> result;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Check revocation for certificate : {}", (Object)certificateToken.getDSSIdAsString());
        }
        if ((result = this.checkOCSP(certificateToken, issuerToken)) != null) {
            return result;
        }
        result = this.checkCRL(certificateToken, issuerToken);
        if (result != null) {
            return result;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("There is no response for {} neither from OCSP nor from CRL!", (Object)certificateToken.getDSSIdAsString());
        }
        return null;
    }

    public RevocationToken<OCSP> checkOCSP(CertificateToken certificateToken, CertificateToken issuerToken) {
        if (this.ocspSource == null) {
            LOG.debug("OCSPSource null");
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("OCSP request for: {} using: {}", (Object)certificateToken.getDSSIdAsString(), (Object)this.ocspSource.getClass().getSimpleName());
        }
        try {
            RevocationToken<OCSP> revocationToken = this.ocspSource.getRevocationToken(certificateToken, issuerToken);
            if (revocationToken != null && revocationToken.getStatus() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("OCSP response for {} retrieved: {}", (Object)certificateToken.getDSSIdAsString(), (Object)revocationToken.getAbbreviation());
                    LOG.debug("OCSP Response {} status is : {}", (Object)revocationToken.getDSSIdAsString(), (Object)revocationToken.getStatus());
                }
                return revocationToken;
            }
        }
        catch (DSSException e) {
            LOG.error("OCSP DSS Exception: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("The retrieved OCSP revocation response for token {} is null!", (Object)certificateToken.getDSSIdAsString());
        }
        return null;
    }

    public RevocationToken<CRL> checkCRL(CertificateToken certificateToken, CertificateToken issuerToken) {
        if (this.crlSource == null) {
            LOG.debug("CRLSource is null");
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CRL request for: {} using: {}", (Object)certificateToken.getDSSIdAsString(), (Object)this.crlSource.getClass().getSimpleName());
        }
        try {
            RevocationToken<CRL> revocationToken = this.crlSource.getRevocationToken(certificateToken, issuerToken);
            if (revocationToken != null && revocationToken.getStatus() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CRL for {} retrieved: {}", (Object)certificateToken.getDSSIdAsString(), (Object)revocationToken.getAbbreviation());
                }
                return revocationToken;
            }
        }
        catch (DSSException e) {
            LOG.error("CRL DSS Exception: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("The retrieved CRL revocation response for token {} is null!", (Object)certificateToken.getDSSIdAsString());
        }
        return null;
    }
}

