/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.DSSException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ByteRange {
    private int[] byteRange;

    public ByteRange(int[] byteRange) {
        this.byteRange = byteRange;
    }

    public int getLength() {
        return this.byteRange[1] - this.byteRange[0] + (this.byteRange[2] - this.byteRange[1]) + this.byteRange[3];
    }

    public int getFirstPartStart() {
        return this.byteRange[0];
    }

    public int getFirstPartEnd() {
        return this.byteRange[1];
    }

    public int getSecondPartStart() {
        return this.byteRange[2];
    }

    public int getSecondPartEnd() {
        return this.byteRange[3];
    }

    public List<BigInteger> toBigIntegerList() {
        ArrayList<BigInteger> bi = new ArrayList<BigInteger>();
        for (int i : this.byteRange) {
            bi.add(BigInteger.valueOf(i));
        }
        return bi;
    }

    public void validate() {
        if (this.byteRange == null || this.byteRange.length != 4) {
            throw new DSSException("Incorrect ByteRange size");
        }
        int a = this.byteRange[0];
        int b = this.byteRange[1];
        int c = this.byteRange[2];
        int d = this.byteRange[3];
        if (a != 0) {
            throw new DSSException("The ByteRange must cover start of file");
        }
        if (b <= 0) {
            throw new DSSException("The first hash part doesn't cover anything");
        }
        if (c <= b) {
            throw new DSSException("The second hash part must start after the first hash part");
        }
        if (d <= 0) {
            throw new DSSException("The second hash part doesn't cover anything");
        }
    }

    public String toString() {
        return Arrays.toString(this.byteRange);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.byteRange);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteRange other = (ByteRange)obj;
        return Arrays.equals(this.byteRange, other.byteRange);
    }
}

