/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.cache.state;

import eu.europa.esig.dss.tsl.cache.state.CacheContext;
import eu.europa.esig.dss.tsl.cache.state.CacheState;
import eu.europa.esig.dss.tsl.cache.state.CachedException;

public enum CacheStateEnum implements CacheState
{
    REFRESH_NEEDED{

        @Override
        public void desync(CacheContext cacheContext) {
            cacheContext.state(DESYNCHRONIZED);
        }

        @Override
        public void refreshNeeded(CacheContext cacheContext) {
            cacheContext.state(REFRESH_NEEDED);
        }

        @Override
        public void error(CacheContext cacheContext, CachedException exception) {
            cacheContext.error(exception);
        }
    }
    ,
    DESYNCHRONIZED{

        @Override
        public void sync(CacheContext cacheContext) {
            cacheContext.state(SYNCHRONIZED);
        }
    }
    ,
    SYNCHRONIZED{

        @Override
        public void desync(CacheContext cacheContext) {
            cacheContext.state(DESYNCHRONIZED);
        }

        @Override
        public void refreshNeeded(CacheContext cacheContext) {
            cacheContext.state(REFRESH_NEEDED);
        }

        @Override
        public void toBeDeleted(CacheContext cacheContext) {
            cacheContext.state(TO_BE_DELETED);
        }

        @Override
        public void sync(CacheContext cacheContext) {
            cacheContext.state(SYNCHRONIZED);
        }
    }
    ,
    ERROR{

        @Override
        public void desync(CacheContext cacheContext) {
            cacheContext.state(DESYNCHRONIZED);
        }

        @Override
        public void refreshNeeded(CacheContext cacheContext) {
            cacheContext.state(REFRESH_NEEDED);
        }

        @Override
        public void toBeDeleted(CacheContext cacheContext) {
            cacheContext.state(TO_BE_DELETED);
        }
    }
    ,
    TO_BE_DELETED;

    private static final String NOT_ALLOWED_TRANSITION = "Transition from '%s' to '%s' is not allowed";

    @Override
    public void sync(CacheContext cacheContext) {
        throw new IllegalStateException(String.format(NOT_ALLOWED_TRANSITION, cacheContext.getCurrentState(), SYNCHRONIZED));
    }

    @Override
    public void desync(CacheContext cacheContext) {
        throw new IllegalStateException(String.format(NOT_ALLOWED_TRANSITION, cacheContext.getCurrentState(), DESYNCHRONIZED));
    }

    @Override
    public void refreshNeeded(CacheContext cacheContext) {
        throw new IllegalStateException(String.format(NOT_ALLOWED_TRANSITION, cacheContext.getCurrentState(), REFRESH_NEEDED));
    }

    @Override
    public void toBeDeleted(CacheContext cacheContext) {
        throw new IllegalStateException(String.format(NOT_ALLOWED_TRANSITION, cacheContext.getCurrentState(), TO_BE_DELETED));
    }

    @Override
    public void error(CacheContext cacheContext, CachedException exception) {
        throw new IllegalStateException("Cannot store error");
    }
}

