/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation.ocsp;

import eu.europa.esig.dss.enumerations.CertificateOrigin;
import eu.europa.esig.dss.enumerations.CertificateRefOrigin;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.x509.CandidatesForSigningCertificate;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.CertificateTokenRefMatcher;
import eu.europa.esig.dss.spi.x509.CertificateValidity;
import eu.europa.esig.dss.spi.x509.ResponderId;
import eu.europa.esig.dss.spi.x509.revocation.RevocationCertificateSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public class OCSPCertificateSource
extends RevocationCertificateSource {
    private final BasicOCSPResp basicOCSPResp;
    private CandidatesForSigningCertificate candidatesForSigningCertificate;

    public OCSPCertificateSource(BasicOCSPResp basicOCSPResp) {
        Objects.requireNonNull(basicOCSPResp, "BasicOCSPResp must be provided!");
        this.basicOCSPResp = basicOCSPResp;
        this.extractCertificateTokens();
        this.extractCertificatRefs();
    }

    private void extractCertificateTokens() {
        for (X509CertificateHolder x509CertificateHolder : this.basicOCSPResp.getCerts()) {
            CertificateToken certificateToken = DSSASN1Utils.getCertificate(x509CertificateHolder);
            this.addCertificate(certificateToken, CertificateOrigin.BASIC_OCSP_RESP);
        }
    }

    private void extractCertificatRefs() {
        ResponderId responderId = DSSRevocationUtils.getDSSResponderId(this.basicOCSPResp.getResponderId());
        CertificateRef signingCertificateRef = new CertificateRef();
        signingCertificateRef.setResponderId(responderId);
        signingCertificateRef.setOrigin(CertificateRefOrigin.SIGNING_CERTIFICATE);
        this.addCertificateRef(signingCertificateRef, CertificateRefOrigin.SIGNING_CERTIFICATE);
    }

    public CandidatesForSigningCertificate getCandidatesForSigningCertificate(CertificateToken certificateIssuer) {
        if (this.candidatesForSigningCertificate == null) {
            this.candidatesForSigningCertificate = this.extractCandidatesForSigningCertificate(certificateIssuer);
        }
        return this.candidatesForSigningCertificate;
    }

    private CandidatesForSigningCertificate extractCandidatesForSigningCertificate(CertificateToken certificateIssuer) {
        CandidatesForSigningCertificate candidatesForSigningCertificate = new CandidatesForSigningCertificate();
        candidatesForSigningCertificate.add(new CertificateValidity(certificateIssuer));
        for (CertificateToken certificateToken : this.getCertificates()) {
            candidatesForSigningCertificate.add(new CertificateValidity(certificateToken));
        }
        List<CertificateRef> signingCertificateRefs = this.getCertificateRefsByOrigin(CertificateRefOrigin.SIGNING_CERTIFICATE);
        if (Utils.isCollectionNotEmpty(signingCertificateRefs)) {
            CertificateTokenRefMatcher matcher = new CertificateTokenRefMatcher();
            CertificateRef signingCertificateRef = signingCertificateRefs.iterator().next();
            for (CertificateValidity certificateValidity : candidatesForSigningCertificate.getCertificateValidityList()) {
                certificateValidity.setResponderIdPresent(signingCertificateRef.getResponderId() != null);
                CertificateToken certificateToken = certificateValidity.getCertificateToken();
                if (certificateToken == null) continue;
                certificateValidity.setResponderIdMatch(matcher.matchByResponderId(certificateToken, signingCertificateRef));
            }
        }
        return candidatesForSigningCertificate;
    }

    @Override
    public CertificateSourceType getCertificateSourceType() {
        return CertificateSourceType.OCSP_RESPONSE;
    }
}

