/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509.revocation;

import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRefIdentifier;
import eu.europa.esig.dss.utils.Utils;
import java.io.Serializable;

public abstract class RevocationRef<R extends Revocation>
implements Serializable {
    private static final long serialVersionUID = 7313118727647264457L;
    protected Digest digest = null;
    private Identifier identifier;

    public Digest getDigest() {
        return this.digest;
    }

    public Identifier getDSSId() {
        if (this.identifier == null) {
            this.identifier = this.createIdentifier();
        }
        return this.identifier;
    }

    protected Identifier createIdentifier() {
        return new RevocationRefIdentifier(this);
    }

    public String getDSSIdAsString() {
        return this.getDSSId().asXmlId();
    }

    public String toString() {
        return Utils.toBase64(this.digest.getValue());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.digest == null ? 0 : this.digest.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RevocationRef other = (RevocationRef)obj;
        return !(this.digest == null ? other.digest != null : !this.digest.equals(other.digest));
    }
}

