/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.service.ocsp;

import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSRevocationUtils;
import eu.europa.esig.dss.spi.x509.revocation.JdbcRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationException;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPSource;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPToken;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCacheOCSPSource
extends JdbcRevocationSource<OCSP>
implements OCSPSource {
    private static final long serialVersionUID = 10480458323923489L;
    private static final Logger LOG = LoggerFactory.getLogger(JdbcCacheOCSPSource.class);
    private static final String SQL_INIT_CHECK_EXISTENCE = "SELECT COUNT(*) FROM CACHED_OCSP";
    private static final String SQL_INIT_CREATE_TABLE = "CREATE TABLE CACHED_OCSP (ID VARCHAR(100), DATA BLOB, LOC VARCHAR(200))";
    private static final String SQL_FIND_QUERY = "SELECT * FROM CACHED_OCSP WHERE ID = ?";
    private static final String SQL_FIND_QUERY_DATA = "DATA";
    private static final String SQL_FIND_QUERY_LOC = "LOC";
    private static final String SQL_FIND_INSERT = "INSERT INTO CACHED_OCSP (ID, DATA, LOC) VALUES (?, ?, ?)";
    private static final String SQL_FIND_UPDATE = "UPDATE CACHED_OCSP SET DATA = ?, LOC = ? WHERE ID = ?";
    private static final String SQL_FIND_REMOVE = "DELETE FROM CACHED_OCSP WHERE ID = ?";
    private static final String SQL_DROP_TABLE = "DROP TABLE CACHED_OCSP";

    @Override
    protected String getCreateTableQuery() {
        return SQL_INIT_CREATE_TABLE;
    }

    @Override
    protected String getTableExistenceQuery() {
        return SQL_INIT_CHECK_EXISTENCE;
    }

    @Override
    protected String getFindRevocationQuery() {
        return SQL_FIND_QUERY;
    }

    @Override
    protected String getRemoveRevocationTokenEntryQuery() {
        return SQL_FIND_REMOVE;
    }

    @Override
    protected String getDeleteTableQuery() {
        return SQL_DROP_TABLE;
    }

    @Override
    public final List<String> initRevocationTokenKey(CertificateToken certificateToken) {
        return DSSRevocationUtils.getOcspRevocationTokenKeys(certificateToken);
    }

    protected OCSPToken buildRevocationTokenFromResult(ResultSet rs, CertificateToken certificateToken, CertificateToken issuerCert) {
        try {
            byte[] data = rs.getBytes(SQL_FIND_QUERY_DATA);
            String url = rs.getString(SQL_FIND_QUERY_LOC);
            OCSPResp ocspResp = new OCSPResp(data);
            BasicOCSPResp basicResponse = (BasicOCSPResp)ocspResp.getResponseObject();
            SingleResp latestSingleResponse = DSSRevocationUtils.getLatestSingleResponse(basicResponse, certificateToken, issuerCert);
            OCSPToken ocspToken = new OCSPToken(basicResponse, latestSingleResponse, certificateToken, issuerCert);
            ocspToken.setSourceURL(url);
            ocspToken.setExternalOrigin(RevocationOrigin.CACHED);
            return ocspToken;
        }
        catch (IOException | SQLException | OCSPException e) {
            throw new RevocationException("An error occurred during an attempt to obtain a revocation token");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void insertRevocation(RevocationToken<OCSP> token) {
        Connection c = null;
        PreparedStatement s2 = null;
        try {
            c = this.dataSource.getConnection();
            s2 = c.prepareStatement(SQL_FIND_INSERT);
            s2.setString(1, token.getRevocationTokenKey());
            s2.setBytes(2, token.getEncoded());
            if (token.getSourceURL() != null) {
                s2.setString(3, token.getSourceURL());
            } else {
                s2.setNull(3, 12);
            }
            s2.executeUpdate();
            c.commit();
            LOG.debug("OCSP token with key '{}' successfully inserted in DB", (Object)token.getRevocationTokenKey());
        }
        catch (Exception e) {
            try {
                LOG.error("Unable to insert OCSP {} into the DB. Cause: '{}'", token, e.getMessage(), e);
                this.rollback(c);
            }
            catch (Throwable throwable) {
                this.closeQuietly(c, s2, null);
                throw throwable;
            }
            this.closeQuietly(c, s2, null);
        }
        this.closeQuietly(c, s2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateRevocation(RevocationToken<OCSP> token) {
        Connection c = null;
        PreparedStatement s2 = null;
        try {
            c = this.dataSource.getConnection();
            s2 = c.prepareStatement(SQL_FIND_UPDATE);
            s2.setBytes(1, token.getEncoded());
            if (token.getSourceURL() != null) {
                s2.setString(2, token.getSourceURL());
            } else {
                s2.setNull(2, 12);
            }
            s2.executeUpdate();
            c.commit();
            LOG.debug("OCSP token with key '{}' successfully updated in DB", (Object)token.getRevocationTokenKey());
        }
        catch (Exception e) {
            try {
                LOG.error("Unable to update OCSP {} into the DB. Cause: '{}'", token, e.getMessage(), e);
                this.rollback(c);
            }
            catch (Throwable throwable) {
                this.closeQuietly(c, s2, null);
                throw throwable;
            }
            this.closeQuietly(c, s2, null);
        }
        this.closeQuietly(c, s2, null);
    }

    @Override
    public OCSPToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken) {
        return (OCSPToken)super.getRevocationToken(certificateToken, issuerCertificateToken);
    }

    public OCSPToken getRevocationToken(CertificateToken certificateToken, CertificateToken issuerCertificateToken, boolean forceRefresh) {
        return (OCSPToken)super.getRevocationToken(certificateToken, issuerCertificateToken, forceRefresh);
    }
}

