/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades.validation.scope;

import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.pades.PAdESUtils;
import eu.europa.esig.dss.pades.validation.PAdESSignature;
import eu.europa.esig.dss.pades.validation.scope.PdfByteRangeSignatureScope;
import eu.europa.esig.dss.pdf.PdfCMSRevision;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.validation.scope.AbstractSignatureScopeFinder;
import eu.europa.esig.dss.validation.scope.FullSignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import java.util.Arrays;
import java.util.List;

public class PAdESSignatureScopeFinder
extends AbstractSignatureScopeFinder<PAdESSignature> {
    @Override
    public List<SignatureScope> findSignatureScope(PAdESSignature pAdESSignature) {
        return Arrays.asList(this.findSignatureScope(pAdESSignature.getPdfRevision()));
    }

    public SignatureScope findSignatureScope(PdfCMSRevision pdfRevision) {
        if (pdfRevision.areAllOriginalBytesCovered()) {
            return new FullSignatureScope("Full PDF", this.getOriginalPdfDigest(pdfRevision));
        }
        return new PdfByteRangeSignatureScope("Partial PDF", pdfRevision.getByteRange(), this.getOriginalPdfDigest(pdfRevision));
    }

    private Digest getOriginalPdfDigest(PdfCMSRevision pdfRevision) {
        InMemoryDocument originalDocument = PAdESUtils.getOriginalPDF(pdfRevision);
        return new Digest(this.getDefaultDigestAlgorithm(), DSSUtils.digest(this.getDefaultDigestAlgorithm(), originalDocument));
    }
}

