/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jaxb;

import eu.europa.esig.dss.jaxb.AbstractFactoryBuilder;
import javax.xml.validation.SchemaFactory;

public class SchemaFactoryBuilder
extends AbstractFactoryBuilder<SchemaFactory> {
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";

    private SchemaFactoryBuilder() {
        this.enableFeature("http://javax.xml.XMLConstants/feature/secure-processing");
        this.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        this.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
    }

    public static SchemaFactoryBuilder getSecureSchemaBuilder() {
        return new SchemaFactoryBuilder();
    }

    public SchemaFactory build() {
        SchemaFactory sf = SchemaFactory.newInstance(this.schemaLanguage);
        this.setSecurityFeatures(sf);
        this.setSecurityAttributes(sf);
        return sf;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public SchemaFactoryBuilder enableFeature(String feature) {
        return (SchemaFactoryBuilder)super.enableFeature(feature);
    }

    public SchemaFactoryBuilder disableFeature(String feature) {
        return (SchemaFactoryBuilder)super.disableFeature(feature);
    }

    public SchemaFactoryBuilder setAttribute(String attribute, Object value) {
        return (SchemaFactoryBuilder)super.setAttribute(attribute, value);
    }

    public SchemaFactoryBuilder removeAttribute(String attribute) {
        return (SchemaFactoryBuilder)super.removeAttribute(attribute);
    }

    @Override
    protected void setSecurityFeature(SchemaFactory factory, String feature, Boolean value) throws Exception {
        factory.setFeature(feature, value);
    }

    @Override
    protected void setSecurityAttribute(SchemaFactory factory, String attribute, Object value) throws Exception {
        factory.setProperty(attribute, value);
    }
}

