/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import eu.europa.esig.dss.enumerations.UriBasedEnum;
import java.util.HashMap;
import java.util.Map;

public enum SignatureQualification implements UriBasedEnum
{
    QESIG("QESig", "Qualified Electronic Signature", "urn:cef:dss:signatureQualification:QESig"),
    QESEAL("QESeal", "Qualified Electronic Seal", "urn:cef:dss:signatureQualification:QESeal"),
    QES("QES?", "Qualified Electronic Signature or Seal", "urn:cef:dss:signatureQualification:QES"),
    ADESIG_QC("AdESig-QC", "Advanced Electronic Signature supported by a Qualified Certificate", "urn:cef:dss:signatureQualification:AdESigQC"),
    ADESEAL_QC("AdESeal-QC", "Advanced Electronic Seal supported by a Qualified Certificate", "urn:cef:dss:signatureQualification:AdESealQC"),
    ADES_QC("AdES?-QC", "Advanced Electronic Signature or Seal supported by a Qualified Certificate", "urn:cef:dss:signatureQualification:AdESQC"),
    ADESIG("AdESig", "Advanced Electronic Signature", "urn:cef:dss:signatureQualification:AdESig"),
    ADESEAL("AdESeal", "Advanced Electronic Seal", "urn:cef:dss:signatureQualification:AdESeal"),
    ADES("AdES?", "Advanced Electronic Signature or Seal", "urn:cef:dss:signatureQualification:AdES"),
    INDETERMINATE_QESIG("Indeterminate QESig", "Indeterminate Qualified Electronic Signature", "urn:cef:dss:signatureQualification:indeterminateQESig"),
    INDETERMINATE_QESEAL("Indeterminate QESeal", "Indeterminate Qualified Electronic Seal", "urn:cef:dss:signatureQualification:indeterminateQESeal"),
    INDETERMINATE_QES("Indeterminate QES?", "Indeterminate Qualified Electronic Signature or Seal", "urn:cef:dss:signatureQualification:indeterminateQES"),
    INDETERMINATE_ADESIG_QC("Indeterminate AdESig-QC", "Indeterminate Advanced Electronic Signature supported by a Qualified Certificate", "urn:cef:dss:signatureQualification:indeterminateAdESigQC"),
    INDETERMINATE_ADESEAL_QC("Indeterminate AdESeal-QC", "Indeterminate Advanced Electronic Seal supported by a Qualified Certificate", "urn:cef:dss:signatureQualification:indeterminateAdESealQC"),
    INDETERMINATE_ADES_QC("Indeterminate AdES?-QC", "Indeterminate Advanced Electronic Signature or Seal supported by a Qualified Certificate", "urn:cef:dss:signatureQualification:indeterminateAdESQC"),
    INDETERMINATE_ADESIG("Indeterminate AdESig", "Indeterminate Advanced Electronic Signature", "urn:cef:dss:signatureQualification:indeterminateAdESig"),
    INDETERMINATE_ADESEAL("Indeterminate AdESeal", "Indeterminate Advanced Electronic Seal", "urn:cef:dss:signatureQualification:indeterminateAdESeal"),
    INDETERMINATE_ADES("Indeterminate AdES?", "Indeterminate Advanced Electronic Signature or Seal", "urn:cef:dss:signatureQualification:indeterminateAdES"),
    NOT_ADES_QC_QSCD("Not AdES but QC with QSCD", "Not Advanced Electronic Signature but supported by a Qualified Certificate", "urn:cef:dss:signatureQualification:notAdESbutQCwithQSCD"),
    NOT_ADES_QC("Not AdES but QC", "Not Advanced Electronic Signature but supported by a Qualified Certificate", "urn:cef:dss:signatureQualification:notAdESbutQC"),
    NOT_ADES("Not AdES", "Not Advanced Electronic Signature", "urn:cef:dss:signatureQualification:notAdES"),
    NA("N/A", "Not applicable", "urn:cef:dss:signatureQualification:notApplicable");

    private final String readable;
    private final String label;
    private final String uri;

    private SignatureQualification(String readable, String label, String uri) {
        this.readable = readable;
        this.label = label;
        this.uri = uri;
    }

    public String getReadable() {
        return this.readable;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public static SignatureQualification forName(String value) {
        if (value != null && !value.isEmpty()) {
            return SignatureQualification.valueOf(value);
        }
        return null;
    }

    public static SignatureQualification fromReadable(String readable) {
        if (readable != null && !readable.isEmpty()) {
            return (SignatureQualification)Registry.QUALIFS_BY_READABLE.get(readable);
        }
        return null;
    }

    public static SignatureQualification forURI(String uri) {
        if (uri != null && !uri.isEmpty()) {
            for (SignatureQualification signatureQualification : SignatureQualification.values()) {
                if (!uri.equals(signatureQualification.uri)) continue;
                return signatureQualification;
            }
        }
        return null;
    }

    private static class Registry {
        private static final Map<String, SignatureQualification> QUALIFS_BY_READABLE = Registry.registerByReadable();

        private Registry() {
        }

        private static Map<String, SignatureQualification> registerByReadable() {
            HashMap<String, SignatureQualification> map = new HashMap<String, SignatureQualification>();
            for (SignatureQualification qualification : SignatureQualification.values()) {
                map.put(qualification.readable, qualification);
            }
            return map;
        }
    }
}

