/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRevocationRef;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import java.util.Date;
import java.util.List;

public class RevocationRefWrappper {
    private final XmlRevocationRef revocationRef;

    public RevocationRefWrappper(XmlRevocationRef revocationRef) {
        this.revocationRef = revocationRef;
    }

    public List<RevocationRefOrigin> getOrigins() {
        return this.revocationRef.getOrigins();
    }

    public Date getProductionTime() {
        return this.revocationRef.getProducedAt();
    }

    public String getResponderIdName() {
        if (this.revocationRef.getResponderId() != null) {
            return this.revocationRef.getResponderId().getIssuerName();
        }
        return null;
    }

    public byte[] getResponderIdKey() {
        if (this.revocationRef.getResponderId() != null) {
            return this.revocationRef.getResponderId().getSki();
        }
        return null;
    }

    public XmlDigestAlgoAndValue getDigestAlgoAndValue() {
        return this.revocationRef.getDigestAlgoAndValue();
    }

    public String toString() {
        if (this.revocationRef != null) {
            return "RevocationRefWrapper Origins='" + this.revocationRef.getOrigins().toArray() + "',  ProductionTime='" + this.revocationRef.getProducedAt() + "', responderIdName='" + this.revocationRef.getResponderId().getIssuerName() + "'";
        }
        return "RevocationRefWrapper revocationRef=" + this.revocationRef;
    }
}

