/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.common.validation;

import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.ContainerInfo;
import eu.europa.esig.dss.validation.DiagnosticDataBuilder;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.SignedDocumentValidator;
import eu.europa.esig.dss.validation.ValidationContext;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractASiCContainerValidator
extends SignedDocumentValidator {
    protected List<DocumentValidator> signatureValidators;
    protected List<DocumentValidator> timestampValidators;
    protected ASiCExtractResult extractResult;
    private ASiCContainerType containerType;

    protected AbstractASiCContainerValidator(DSSDocument document) {
        this.document = document;
    }

    protected void analyseEntries() {
        AbstractASiCContainerExtractor extractor = this.getArchiveExtractor();
        this.extractResult = extractor.extract();
        this.containerType = ASiCUtils.getContainerType(this.document, this.extractResult.getMimeTypeDocument(), this.extractResult.getZipComment(), this.extractResult.getSignedDocuments());
        if (ASiCContainerType.ASiC_S.equals((Object)this.containerType)) {
            this.extractResult.setContainerDocuments(this.getArchiveDocuments(this.extractResult.getSignedDocuments()));
        }
    }

    protected abstract AbstractASiCContainerExtractor getArchiveExtractor();

    public ASiCContainerType getContainerType() {
        return this.containerType;
    }

    @Override
    protected DiagnosticDataBuilder getDiagnosticDataBuilderConfiguration(ValidationContext validationContext, List<AdvancedSignature> signatures, ListRevocationSource<CRL> listCRLSource, ListRevocationSource<OCSP> listOCSPSource) {
        return super.getDiagnosticDataBuilderConfiguration(validationContext, signatures, listCRLSource, listOCSPSource).containerInfo(this.getContainerInfo());
    }

    protected ContainerInfo getContainerInfo() {
        ContainerInfo containerInfo = new ContainerInfo();
        containerInfo.setContainerType(this.containerType);
        containerInfo.setZipComment(this.extractResult.getZipComment());
        DSSDocument mimeTypeDocument = this.extractResult.getMimeTypeDocument();
        if (mimeTypeDocument != null) {
            String mimeTypeContent = new String(DSSUtils.toByteArray(mimeTypeDocument));
            containerInfo.setMimeTypeFilePresent(true);
            containerInfo.setMimeTypeContent(mimeTypeContent);
        } else {
            containerInfo.setMimeTypeFilePresent(false);
        }
        List<DSSDocument> originalSignedDocuments = this.extractResult.getSignedDocuments();
        if (Utils.isCollectionNotEmpty(originalSignedDocuments)) {
            ArrayList<String> signedDocumentFilenames = new ArrayList<String>();
            for (DSSDocument dssDocument : originalSignedDocuments) {
                signedDocumentFilenames.add(dssDocument.getName());
            }
            containerInfo.setSignedDocumentFilenames(signedDocumentFilenames);
        }
        containerInfo.setManifestFiles(this.getManifestFiles());
        return containerInfo;
    }

    protected List<TimestampToken> attachExternalTimestamps(List<AdvancedSignature> allSignatures) {
        return Collections.emptyList();
    }

    protected abstract List<ManifestFile> getManifestFilesDecriptions();

    @Override
    protected List<AdvancedSignature> getAllSignatures() {
        this.setSignedScopeFinderDefaultDigestAlgorithm(this.certificateVerifier.getDefaultDigestAlgorithm());
        ArrayList<AdvancedSignature> allSignatureList = new ArrayList<AdvancedSignature>();
        List<DocumentValidator> currentValidators = this.getSignatureValidators();
        for (DocumentValidator signatureValidator : currentValidators) {
            ArrayList<AdvancedSignature> currentValidatorSignatures = new ArrayList<AdvancedSignature>();
            for (AdvancedSignature advancedSignature : signatureValidator.getSignatures()) {
                currentValidatorSignatures.add(advancedSignature);
                currentValidatorSignatures.addAll(advancedSignature.getCounterSignatures());
            }
            signatureValidator.findSignatureScopes(currentValidatorSignatures);
            allSignatureList.addAll(currentValidatorSignatures);
        }
        this.attachExternalTimestamps(allSignatureList);
        return allSignatureList;
    }

    @Override
    public List<AdvancedSignature> getSignatures() {
        ArrayList<AdvancedSignature> signatureList = new ArrayList<AdvancedSignature>();
        for (DocumentValidator validator : this.getSignatureValidators()) {
            for (AdvancedSignature advancedSignature : validator.getSignatures()) {
                signatureList.add(advancedSignature);
                signatureList.addAll(advancedSignature.getCounterSignatures());
            }
        }
        return signatureList;
    }

    protected abstract List<DocumentValidator> getSignatureValidators();

    public List<DSSDocument> getSignatureDocuments() {
        return this.extractResult.getSignatureDocuments();
    }

    public List<DSSDocument> getSignedDocuments() {
        return this.extractResult.getSignedDocuments();
    }

    public List<DSSDocument> getAllDocuments() {
        return this.extractResult.getAllDocuments();
    }

    public List<DSSDocument> getManifestDocuments() {
        return this.extractResult.getManifestDocuments();
    }

    public List<DSSDocument> getTimestampDocuments() {
        return this.extractResult.getTimestampDocuments();
    }

    public List<DSSDocument> getArchiveManifestDocuments() {
        return this.extractResult.getArchiveManifestDocuments();
    }

    public List<DSSDocument> getAllManifestDocuments() {
        return this.extractResult.getAllManifestDocuments();
    }

    public List<DSSDocument> getArchiveDocuments() {
        return this.extractResult.getContainerDocuments();
    }

    public DSSDocument getMimeTypeDocument() {
        return this.extractResult.getMimeTypeDocument();
    }

    public List<DSSDocument> getUnsupportedDocuments() {
        return this.extractResult.getUnsupportedDocuments();
    }

    public List<ManifestFile> getManifestFiles() {
        if (this.manifestFiles == null) {
            this.manifestFiles = this.getManifestFilesDecriptions();
        }
        return this.manifestFiles;
    }

    private List<DSSDocument> getArchiveDocuments(List<DSSDocument> foundDocuments) {
        ArrayList<DSSDocument> archiveDocuments = new ArrayList<DSSDocument>();
        for (DSSDocument document : foundDocuments) {
            if (!ASiCUtils.isASiCSArchive(document)) continue;
            archiveDocuments.addAll(ASiCUtils.getPackageZipContent(document));
            break;
        }
        return archiveDocuments;
    }

    protected List<DSSDocument> getSignedDocumentsASiCS(List<DSSDocument> retrievedDocs) {
        if (Utils.collectionSize(retrievedDocs) > 1) {
            throw new DSSException("ASiC-S : More than one file");
        }
        DSSDocument uniqueDoc = retrievedDocs.get(0);
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        if (ASiCUtils.isASiCSArchive(uniqueDoc)) {
            result.addAll(ASiCUtils.getPackageZipContent(uniqueDoc));
        } else {
            result.add(uniqueDoc);
        }
        return result;
    }
}

