/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.manifest;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.asic.cades.signature.manifest.AbstractManifestBuilder;
import eu.europa.esig.dss.asic.common.definition.ASiCAttribute;
import eu.europa.esig.dss.asic.common.definition.ASiCElement;
import eu.europa.esig.dss.asic.common.definition.ASiCNamespace;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.MimeType;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ASiCEWithCAdESArchiveManifestBuilder
extends AbstractManifestBuilder {
    private final List<DSSDocument> signatures;
    private final List<DSSDocument> timestamps;
    private final List<DSSDocument> documents;
    private final List<DSSDocument> manifests;
    private final DSSDocument lastArchiveManifest;
    private final DigestAlgorithm digestAlgorithm;
    private final String timestampUri;

    public ASiCEWithCAdESArchiveManifestBuilder(List<DSSDocument> signatures, List<DSSDocument> timestamps, List<DSSDocument> documents, List<DSSDocument> manifests, DSSDocument lastArchiveManifets, DigestAlgorithm digestAlgorithm, String timestampUri) {
        this.signatures = signatures;
        this.timestamps = timestamps;
        this.documents = documents;
        this.manifests = manifests;
        this.lastArchiveManifest = lastArchiveManifets;
        this.digestAlgorithm = digestAlgorithm;
        this.timestampUri = timestampUri;
    }

    public Document build() {
        Document documentDom = DomUtils.buildDOM();
        Element asicManifestDom = DomUtils.createElementNS(documentDom, ASiCNamespace.NS, ASiCElement.ASIC_MANIFEST);
        documentDom.appendChild(asicManifestDom);
        this.addSigReference(documentDom, asicManifestDom, this.timestampUri, MimeType.TST);
        for (DSSDocument signature : this.signatures) {
            this.addDataObjectReference(documentDom, asicManifestDom, signature, this.digestAlgorithm);
        }
        for (DSSDocument timestamp : this.timestamps) {
            this.addDataObjectReference(documentDom, asicManifestDom, timestamp, this.digestAlgorithm);
        }
        for (DSSDocument manifest : this.manifests) {
            this.addDataObjectReference(documentDom, asicManifestDom, manifest, this.digestAlgorithm);
        }
        if (this.lastArchiveManifest != null) {
            this.addDataObjectReferenceForRootArchiveManifest(documentDom, asicManifestDom, this.lastArchiveManifest, this.digestAlgorithm);
        }
        for (DSSDocument document : this.documents) {
            this.addDataObjectReference(documentDom, asicManifestDom, document, this.digestAlgorithm);
        }
        return documentDom;
    }

    private Element addDataObjectReferenceForRootArchiveManifest(Document documentDom, Element asicManifestDom, DSSDocument document, DigestAlgorithm digestAlgorithm) {
        Element dataObjectReferenceElement = this.addDataObjectReference(documentDom, asicManifestDom, document, digestAlgorithm);
        dataObjectReferenceElement.setAttribute(ASiCAttribute.ROOTFILE.getAttributeName(), "true");
        return dataObjectReferenceElement;
    }
}

