/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;

public final class NamespaceContextMap
implements NamespaceContext {
    private final Map<String, String> prefixMap = new HashMap<String, String>();
    private final Map<String, Set<String>> namespaceMap = new HashMap<String, Set<String>>();

    public boolean registerNamespace(String prefix, String namespace) {
        String put = this.prefixMap.put(prefix, namespace);
        this.createNamespace(prefix, namespace);
        return put == null;
    }

    private void createNamespace(String prefix, String namespace) {
        Set prefixes = this.namespaceMap.computeIfAbsent(namespace, k -> new HashSet());
        prefixes.add(prefix);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        this.checkNotNull(prefix);
        String nsURI = this.prefixMap.get(prefix);
        return nsURI == null ? "" : nsURI;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        this.checkNotNull(namespaceURI);
        Set<String> set = this.namespaceMap.get(namespaceURI);
        return set == null ? null : set.iterator().next();
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        this.checkNotNull(namespaceURI);
        Set<String> set = this.namespaceMap.get(namespaceURI);
        return set.iterator();
    }

    private void checkNotNull(String value) {
        if (value == null) {
            throw new IllegalArgumentException("null");
        }
    }
}

