/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.timestamp;

import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.model.identifier.Identifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.x509.CertificateRef;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.spi.x509.revocation.OfflineRevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.ocsp.OCSPRef;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.ISignatureAttribute;
import eu.europa.esig.dss.validation.ListRevocationSource;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureProperties;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import eu.europa.esig.dss.validation.timestamp.TimestampCRLSource;
import eu.europa.esig.dss.validation.timestamp.TimestampDataBuilder;
import eu.europa.esig.dss.validation.timestamp.TimestampOCSPSource;
import eu.europa.esig.dss.validation.timestamp.TimestampSource;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTimestampSource<SignatureAttribute extends ISignatureAttribute>
implements TimestampSource {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTimestampSource.class);
    protected final SignatureCertificateSource signatureCertificateSource;
    protected final OfflineRevocationSource<CRL> signatureCRLSource;
    protected final OfflineRevocationSource<OCSP> signatureOCSPSource;
    protected final String signatureId;
    protected final transient List<SignatureScope> signatureScopes;
    protected ListRevocationSource<CRL> crlSource;
    protected ListRevocationSource<OCSP> ocspSource;
    protected ListCertificateSource certificateSource;
    private List<TimestampToken> contentTimestamps;
    private List<TimestampToken> signatureTimestamps;
    private List<TimestampToken> sigAndRefsTimestamps;
    private List<TimestampToken> refsOnlyTimestamps;
    private List<TimestampToken> archiveTimestamps;

    protected AbstractTimestampSource(AdvancedSignature signature) {
        Objects.requireNonNull(signature, "The signature cannot be null!");
        this.signatureCertificateSource = signature.getCertificateSource();
        this.signatureCRLSource = signature.getCRLSource();
        this.signatureOCSPSource = signature.getOCSPSource();
        this.signatureId = signature.getId();
        this.signatureScopes = signature.getSignatureScopes();
    }

    @Override
    public List<TimestampToken> getContentTimestamps() {
        if (this.contentTimestamps == null) {
            this.createAndValidate();
        }
        return this.contentTimestamps;
    }

    @Override
    public List<TimestampToken> getSignatureTimestamps() {
        if (this.signatureTimestamps == null) {
            this.createAndValidate();
        }
        return this.signatureTimestamps;
    }

    @Override
    public List<TimestampToken> getTimestampsX1() {
        if (this.sigAndRefsTimestamps == null) {
            this.createAndValidate();
        }
        return this.sigAndRefsTimestamps;
    }

    @Override
    public List<TimestampToken> getTimestampsX2() {
        if (this.refsOnlyTimestamps == null) {
            this.createAndValidate();
        }
        return this.refsOnlyTimestamps;
    }

    @Override
    public List<TimestampToken> getArchiveTimestamps() {
        if (this.archiveTimestamps == null) {
            this.createAndValidate();
        }
        return this.archiveTimestamps;
    }

    @Override
    public List<TimestampToken> getDocumentTimestamps() {
        return Collections.emptyList();
    }

    @Override
    public List<TimestampToken> getAllTimestamps() {
        ArrayList<TimestampToken> timestampTokens = new ArrayList<TimestampToken>();
        timestampTokens.addAll(this.getContentTimestamps());
        timestampTokens.addAll(this.getSignatureTimestamps());
        timestampTokens.addAll(this.getTimestampsX1());
        timestampTokens.addAll(this.getTimestampsX2());
        timestampTokens.addAll(this.getArchiveTimestamps());
        return timestampTokens;
    }

    @Override
    public ListCertificateSource getTimestampCertificateSources() {
        ListCertificateSource result = new ListCertificateSource();
        for (TimestampToken timestampToken : this.getAllTimestamps()) {
            result.add(timestampToken.getCertificateSource());
        }
        return result;
    }

    @Override
    public ListCertificateSource getTimestampCertificateSourcesExceptLastArchiveTimestamp() {
        ListCertificateSource result = new ListCertificateSource();
        for (TimestampToken timestampToken : this.getContentTimestamps()) {
            result.add(timestampToken.getCertificateSource());
        }
        for (TimestampToken timestampToken : this.getTimestampsX1()) {
            result.add(timestampToken.getCertificateSource());
        }
        for (TimestampToken timestampToken : this.getTimestampsX2()) {
            result.add(timestampToken.getCertificateSource());
        }
        for (TimestampToken timestampToken : this.getSignatureTimestamps()) {
            result.add(timestampToken.getCertificateSource());
        }
        List<TimestampToken> archiveTsps = this.getArchiveTimestamps();
        int archiveTimestampsSize = archiveTsps.size();
        if (archiveTimestampsSize > 0) {
            --archiveTimestampsSize;
        }
        for (int ii = 0; ii < archiveTimestampsSize; ++ii) {
            TimestampToken timestampToken = archiveTsps.get(ii);
            result.add(timestampToken.getCertificateSource());
        }
        return result;
    }

    @Override
    public ListRevocationSource<CRL> getTimestampCRLSources() {
        ListRevocationSource<CRL> result = new ListRevocationSource<CRL>();
        for (TimestampToken timestampToken : this.getAllTimestamps()) {
            result.add(timestampToken.getCRLSource());
        }
        return result;
    }

    @Override
    public ListRevocationSource<OCSP> getTimestampOCSPSources() {
        ListRevocationSource<OCSP> result = new ListRevocationSource<OCSP>();
        for (TimestampToken timestampToken : this.getAllTimestamps()) {
            result.add(timestampToken.getOCSPSource());
        }
        return result;
    }

    protected void createAndValidate() {
        this.makeTimestampTokens();
        this.validateTimestamps();
    }

    @Override
    public void addExternalTimestamp(TimestampToken timestamp) {
        if (this.archiveTimestamps == null) {
            this.createAndValidate();
        }
        this.processExternalTimestamp(timestamp);
        if (TimestampType.ARCHIVE_TIMESTAMP != timestamp.getTimeStampType()) {
            throw new DSSException(String.format("The signature timestamp source does not support timestamp tokens with type [%s]. The TimestampToken was not added.", timestamp.getTimeStampType().name()));
        }
        this.archiveTimestamps.add(timestamp);
    }

    protected void makeTimestampTokens() {
        this.contentTimestamps = new ArrayList<TimestampToken>();
        this.signatureTimestamps = new ArrayList<TimestampToken>();
        this.sigAndRefsTimestamps = new ArrayList<TimestampToken>();
        this.refsOnlyTimestamps = new ArrayList<TimestampToken>();
        this.archiveTimestamps = new ArrayList<TimestampToken>();
        this.crlSource = new ListRevocationSource<CRL>(this.signatureCRLSource);
        this.ocspSource = new ListRevocationSource<OCSP>(this.signatureOCSPSource);
        this.certificateSource = new ListCertificateSource(this.signatureCertificateSource);
        SignatureProperties<SignatureAttribute> signedSignatureProperties = this.getSignedSignatureProperties();
        List<SignatureAttribute> signedAttributes = signedSignatureProperties.getAttributes();
        for (ISignatureAttribute signedAttribute : signedAttributes) {
            List<TimestampedReference> references;
            TimestampToken timestampToken;
            if (this.isContentTimestamp(signedAttribute) ? (timestampToken = this.makeTimestampToken(signedAttribute, TimestampType.CONTENT_TIMESTAMP, this.getAllSignedDataReferences())) == null : (this.isAllDataObjectsTimestamp(signedAttribute) ? (timestampToken = this.makeTimestampToken(signedAttribute, TimestampType.ALL_DATA_OBJECTS_TIMESTAMP, this.getAllSignedDataReferences())) == null : !this.isIndividualDataObjectsTimestamp(signedAttribute) || (timestampToken = this.makeTimestampToken(signedAttribute, TimestampType.INDIVIDUAL_DATA_OBJECTS_TIMESTAMP, references = this.getIndividualContentTimestampedReferences(signedAttribute))) == null)) continue;
            this.populateSources(timestampToken);
            this.contentTimestamps.add(timestampToken);
        }
        SignatureProperties<SignatureAttribute> unsignedSignatureProperties = this.getUnsignedSignatureProperties();
        if (!unsignedSignatureProperties.isExist()) {
            return;
        }
        ArrayList<TimestampToken> timestamps = new ArrayList<TimestampToken>();
        ArrayList<TimestampedReference> encapsulatedReferences = new ArrayList<TimestampedReference>();
        List<SignatureAttribute> unsignedAttributes = unsignedSignatureProperties.getAttributes();
        for (ISignatureAttribute unsignedAttribute : unsignedAttributes) {
            TimestampToken timestampToken;
            if (this.isSignatureTimestamp(unsignedAttribute)) {
                timestampToken = this.makeTimestampToken(unsignedAttribute, TimestampType.SIGNATURE_TIMESTAMP, this.getSignatureTimestampReferences());
                if (timestampToken == null) continue;
                this.signatureTimestamps.add(timestampToken);
            } else {
                ArrayList<TimestampedReference> references;
                if (this.isCompleteCertificateRef(unsignedAttribute)) {
                    this.addReferences(encapsulatedReferences, this.getTimestampedCertificateRefs(unsignedAttribute));
                    continue;
                }
                if (this.isAttributeCertificateRef(unsignedAttribute)) {
                    this.addReferences(encapsulatedReferences, this.getTimestampedCertificateRefs(unsignedAttribute));
                    continue;
                }
                if (this.isCompleteRevocationRef(unsignedAttribute)) {
                    this.addReferences(encapsulatedReferences, this.getTimestampedRevocationRefs(unsignedAttribute));
                    continue;
                }
                if (this.isAttributeRevocationRef(unsignedAttribute)) {
                    this.addReferences(encapsulatedReferences, this.getTimestampedRevocationRefs(unsignedAttribute));
                    continue;
                }
                if (this.isRefsOnlyTimestamp(unsignedAttribute)) {
                    timestampToken = this.makeTimestampToken(unsignedAttribute, TimestampType.VALIDATION_DATA_REFSONLY_TIMESTAMP, encapsulatedReferences);
                    if (timestampToken == null) continue;
                    this.refsOnlyTimestamps.add(timestampToken);
                } else if (this.isSigAndRefsTimestamp(unsignedAttribute)) {
                    references = new ArrayList<TimestampedReference>();
                    this.addReferencesForPreviousTimestamps(references, this.filterSignatureTimestamps(timestamps));
                    this.addReferences(references, encapsulatedReferences);
                    timestampToken = this.makeTimestampToken(unsignedAttribute, TimestampType.VALIDATION_DATA_TIMESTAMP, references);
                    if (timestampToken == null) continue;
                    this.sigAndRefsTimestamps.add(timestampToken);
                } else {
                    if (this.isCertificateValues(unsignedAttribute)) {
                        this.addReferences(encapsulatedReferences, this.getTimestampedCertificateValues(unsignedAttribute));
                        continue;
                    }
                    if (this.isRevocationValues(unsignedAttribute)) {
                        this.addReferences(encapsulatedReferences, this.getTimestampedRevocationValues(unsignedAttribute));
                        continue;
                    }
                    if (this.isAttrAuthoritiesCertValues(unsignedAttribute)) {
                        this.addReferences(encapsulatedReferences, this.getTimestampedCertificateValues(unsignedAttribute));
                        continue;
                    }
                    if (this.isAttributeRevocationValues(unsignedAttribute)) {
                        this.addReferences(encapsulatedReferences, this.getTimestampedRevocationValues(unsignedAttribute));
                        continue;
                    }
                    if (this.isArchiveTimestamp(unsignedAttribute)) {
                        references = new ArrayList();
                        this.addReferencesForPreviousTimestamps(references, timestamps);
                        this.addReferences(references, encapsulatedReferences);
                        timestampToken = this.makeTimestampToken(unsignedAttribute, TimestampType.ARCHIVE_TIMESTAMP, references);
                        if (timestampToken == null) continue;
                        timestampToken.setArchiveTimestampType(this.getArchiveTimestampType(unsignedAttribute));
                        this.addReferences(timestampToken.getTimestampedReferences(), this.getArchiveTimestampOtherReferences(timestampToken));
                        this.archiveTimestamps.add(timestampToken);
                    } else {
                        if (this.isTimeStampValidationData(unsignedAttribute)) {
                            this.addReferences(encapsulatedReferences, this.getTimestampValidationData(unsignedAttribute));
                            continue;
                        }
                        LOG.warn("The unsigned attribute with name [{}] is not supported", (Object)unsignedAttribute);
                        continue;
                    }
                }
            }
            this.populateSources(timestampToken);
            timestamps.add(timestampToken);
        }
    }

    protected abstract SignatureProperties<SignatureAttribute> getSignedSignatureProperties();

    protected abstract SignatureProperties<SignatureAttribute> getUnsignedSignatureProperties();

    protected abstract boolean isContentTimestamp(SignatureAttribute var1);

    protected abstract boolean isAllDataObjectsTimestamp(SignatureAttribute var1);

    protected abstract boolean isIndividualDataObjectsTimestamp(SignatureAttribute var1);

    protected abstract boolean isSignatureTimestamp(SignatureAttribute var1);

    protected abstract boolean isCompleteCertificateRef(SignatureAttribute var1);

    protected abstract boolean isAttributeCertificateRef(SignatureAttribute var1);

    protected abstract boolean isCompleteRevocationRef(SignatureAttribute var1);

    protected abstract boolean isAttributeRevocationRef(SignatureAttribute var1);

    protected abstract boolean isRefsOnlyTimestamp(SignatureAttribute var1);

    protected abstract boolean isSigAndRefsTimestamp(SignatureAttribute var1);

    protected abstract boolean isCertificateValues(SignatureAttribute var1);

    protected abstract boolean isRevocationValues(SignatureAttribute var1);

    protected abstract boolean isAttrAuthoritiesCertValues(SignatureAttribute var1);

    protected abstract boolean isAttributeRevocationValues(SignatureAttribute var1);

    protected abstract boolean isArchiveTimestamp(SignatureAttribute var1);

    protected abstract boolean isTimeStampValidationData(SignatureAttribute var1);

    protected abstract TimestampToken makeTimestampToken(SignatureAttribute var1, TimestampType var2, List<TimestampedReference> var3);

    protected List<TimestampedReference> getAllSignedDataReferences() {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        if (Utils.isCollectionNotEmpty(this.signatureScopes)) {
            for (SignatureScope signatureScope : this.signatureScopes) {
                this.addReference(references, new TimestampedReference(signatureScope.getDSSIdAsString(), TimestampedObjectType.SIGNED_DATA));
            }
        }
        return references;
    }

    protected abstract List<TimestampedReference> getIndividualContentTimestampedReferences(SignatureAttribute var1);

    public List<TimestampedReference> getSignatureTimestampReferences() {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        this.addReferencesForPreviousTimestamps(references, this.getContentTimestamps());
        this.addReferences(references, this.getAllSignedDataReferences());
        this.addReference(references, new TimestampedReference(this.signatureId, TimestampedObjectType.SIGNATURE));
        this.addReferences(references, this.getSigningCertificateTimestampReferences());
        return references;
    }

    protected List<TimestampedReference> getSigningCertificateTimestampReferences() {
        return this.createReferencesForCertificates(this.signatureCertificateSource.getSigningCertificates());
    }

    protected List<TimestampedReference> createReferencesForCertificates(Collection<CertificateToken> certificates) {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        for (CertificateToken certificateToken : certificates) {
            this.addReference(references, new TimestampedReference(certificateToken.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
        return references;
    }

    protected List<TimestampedReference> getTimestampedCertificateRefs(SignatureAttribute unsignedAttribute) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (CertificateRef certRef : this.getCertificateRefs(unsignedAttribute)) {
            timestampedReferences.add(new TimestampedReference(certRef.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
        return timestampedReferences;
    }

    protected abstract List<CertificateRef> getCertificateRefs(SignatureAttribute var1);

    protected List<TimestampedReference> getTimestampedRevocationRefs(SignatureAttribute unsignedAttribute) {
        EncapsulatedRevocationTokenIdentifier token;
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (CRLRef crlRef : this.getCRLRefs(unsignedAttribute)) {
            token = this.crlSource.findBinaryForReference(crlRef);
            if (token != null) {
                timestampedReferences.add(new TimestampedReference(token.asXmlId(), TimestampedObjectType.REVOCATION));
                continue;
            }
            timestampedReferences.add(new TimestampedReference(crlRef.getDSSIdAsString(), TimestampedObjectType.REVOCATION));
        }
        for (OCSPRef ocspRef : this.getOCSPRefs(unsignedAttribute)) {
            token = this.ocspSource.findBinaryForReference(ocspRef);
            if (token != null) {
                timestampedReferences.add(new TimestampedReference(token.asXmlId(), TimestampedObjectType.REVOCATION));
                continue;
            }
            timestampedReferences.add(new TimestampedReference(ocspRef.getDSSIdAsString(), TimestampedObjectType.REVOCATION));
        }
        return timestampedReferences;
    }

    protected abstract List<CRLRef> getCRLRefs(SignatureAttribute var1);

    protected abstract List<OCSPRef> getOCSPRefs(SignatureAttribute var1);

    protected List<TimestampedReference> getTimestampedCertificateValues(SignatureAttribute unsignedAttribute) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (Identifier certificateIdentifier : this.getEncapsulatedCertificateIdentifiers(unsignedAttribute)) {
            timestampedReferences.add(new TimestampedReference(certificateIdentifier.asXmlId(), TimestampedObjectType.CERTIFICATE));
        }
        return timestampedReferences;
    }

    protected abstract List<Identifier> getEncapsulatedCertificateIdentifiers(SignatureAttribute var1);

    protected List<TimestampedReference> getTimestampedRevocationValues(SignatureAttribute unsignedAttribute) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (Identifier revocationIdentifier : this.getEncapsulatedCRLIdentifiers(unsignedAttribute)) {
            timestampedReferences.add(new TimestampedReference(revocationIdentifier.asXmlId(), TimestampedObjectType.REVOCATION));
        }
        for (Identifier revocationIdentifier : this.getEncapsulatedOCSPIdentifiers(unsignedAttribute)) {
            timestampedReferences.add(new TimestampedReference(revocationIdentifier.asXmlId(), TimestampedObjectType.REVOCATION));
        }
        return timestampedReferences;
    }

    protected abstract List<Identifier> getEncapsulatedCRLIdentifiers(SignatureAttribute var1);

    protected abstract List<Identifier> getEncapsulatedOCSPIdentifiers(SignatureAttribute var1);

    protected abstract List<TimestampedReference> getArchiveTimestampOtherReferences(TimestampToken var1);

    protected List<TimestampedReference> getSignatureSignedDataReferences() {
        return new ArrayList<TimestampedReference>();
    }

    protected List<TimestampedReference> getTimestampValidationData(SignatureAttribute unsignedAttribute) {
        ArrayList<TimestampedReference> timestampedReferences = new ArrayList<TimestampedReference>();
        for (Identifier certificateIdentifier : this.getEncapsulatedCertificateIdentifiers(unsignedAttribute)) {
            timestampedReferences.add(new TimestampedReference(certificateIdentifier.asXmlId(), TimestampedObjectType.CERTIFICATE));
        }
        for (Identifier crlIdentifier : this.getEncapsulatedCRLIdentifiers(unsignedAttribute)) {
            timestampedReferences.add(new TimestampedReference(crlIdentifier.asXmlId(), TimestampedObjectType.REVOCATION));
        }
        for (Identifier ocspIdentifier : this.getEncapsulatedOCSPIdentifiers(unsignedAttribute)) {
            timestampedReferences.add(new TimestampedReference(ocspIdentifier.asXmlId(), TimestampedObjectType.REVOCATION));
        }
        return timestampedReferences;
    }

    protected void addReference(List<TimestampedReference> referenceList, TimestampedReference referenceToAdd) {
        this.addReferences(referenceList, Arrays.asList(referenceToAdd));
    }

    protected void addReference(List<TimestampedReference> referenceList, Identifier identifier, TimestampedObjectType category) {
        this.addReferences(referenceList, Arrays.asList(new TimestampedReference(identifier.asXmlId(), category)));
    }

    protected void addReferences(List<TimestampedReference> referenceList, List<TimestampedReference> referencesToAdd) {
        for (TimestampedReference reference : referencesToAdd) {
            if (referenceList.contains(reference)) continue;
            referenceList.add(reference);
        }
    }

    private List<TimestampToken> filterSignatureTimestamps(List<TimestampToken> previousTimestampedTimestamp) {
        ArrayList<TimestampToken> result = new ArrayList<TimestampToken>();
        for (TimestampToken timestampToken : previousTimestampedTimestamp) {
            if (!TimestampType.SIGNATURE_TIMESTAMP.equals((Object)timestampToken.getTimeStampType())) continue;
            result.add(timestampToken);
        }
        return result;
    }

    protected void addReferencesForPreviousTimestamps(List<TimestampedReference> references, List<TimestampToken> timestampedTimestamps) {
        for (TimestampToken timestampToken : timestampedTimestamps) {
            this.addReference(references, new TimestampedReference(timestampToken.getDSSIdAsString(), TimestampedObjectType.TIMESTAMP));
            this.addTimestampedReferences(references, timestampToken);
            this.addEncapsulatedValuesFromTimestamp(references, timestampToken);
        }
    }

    private void addTimestampedReferences(List<TimestampedReference> references, TimestampToken timestampedTimestamp) {
        for (TimestampedReference timestampedReference : timestampedTimestamp.getTimestampedReferences()) {
            this.addReference(references, timestampedReference);
        }
    }

    protected void addEncapsulatedValuesFromTimestamp(List<TimestampedReference> references, TimestampToken timestampedTimestamp) {
        for (CertificateToken certificateToken : timestampedTimestamp.getCertificates()) {
            this.addReference(references, certificateToken.getDSSId(), TimestampedObjectType.CERTIFICATE);
        }
        for (CertificateRef certificateRef : timestampedTimestamp.getCertificateRefs()) {
            this.addReference(references, new TimestampedReference(certificateRef.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
        TimestampCRLSource timestampCRLSource = timestampedTimestamp.getCRLSource();
        for (EncapsulatedRevocationTokenIdentifier revocationBinary : timestampCRLSource.getAllRevocationBinaries()) {
            this.addReference(references, revocationBinary, TimestampedObjectType.REVOCATION);
        }
        for (EncapsulatedRevocationTokenIdentifier revocationBinary : timestampCRLSource.getAllReferencedRevocationBinaries()) {
            this.addReference(references, revocationBinary, TimestampedObjectType.REVOCATION);
        }
        TimestampOCSPSource timestampOCSPSource = timestampedTimestamp.getOCSPSource();
        for (EncapsulatedRevocationTokenIdentifier revocationBinary : timestampOCSPSource.getAllRevocationBinaries()) {
            this.addReference(references, revocationBinary, TimestampedObjectType.REVOCATION);
        }
        for (EncapsulatedRevocationTokenIdentifier revocationBinary : timestampOCSPSource.getAllReferencedRevocationBinaries()) {
            this.addReference(references, revocationBinary, TimestampedObjectType.REVOCATION);
        }
    }

    protected abstract ArchiveTimestampType getArchiveTimestampType(SignatureAttribute var1);

    protected void validateTimestamps() {
        DSSDocument timestampedData;
        TimestampDataBuilder timestampDataBuilder = this.getTimestampDataBuilder();
        for (TimestampToken timestampToken : this.getContentTimestamps()) {
            timestampedData = timestampDataBuilder.getContentTimestampData(timestampToken);
            timestampToken.matchData(timestampedData);
        }
        for (TimestampToken timestampToken : this.getSignatureTimestamps()) {
            timestampedData = timestampDataBuilder.getSignatureTimestampData(timestampToken);
            timestampToken.matchData(timestampedData);
        }
        for (TimestampToken timestampToken : this.getTimestampsX1()) {
            timestampedData = timestampDataBuilder.getTimestampX1Data(timestampToken);
            timestampToken.matchData(timestampedData);
        }
        for (TimestampToken timestampToken : this.getTimestampsX2()) {
            timestampedData = timestampDataBuilder.getTimestampX2Data(timestampToken);
            timestampToken.matchData(timestampedData);
        }
        for (TimestampToken timestampToken : this.getArchiveTimestamps()) {
            if (timestampToken.isProcessed()) continue;
            timestampedData = timestampDataBuilder.getArchiveTimestampData(timestampToken);
            timestampToken.matchData(timestampedData);
        }
    }

    protected abstract TimestampDataBuilder getTimestampDataBuilder();

    private void processExternalTimestamp(TimestampToken externalTimestamp) {
        this.addReferences(externalTimestamp.getTimestampedReferences(), this.getSignatureSignedDataReferences());
        this.addReferencesForPreviousTimestamps(externalTimestamp.getTimestampedReferences(), this.getAllTimestamps());
        this.populateSources(externalTimestamp);
    }

    protected void populateSources(TimestampToken timestampToken) {
        this.certificateSource.add(timestampToken.getCertificateSource());
        this.crlSource.add(timestampToken.getCRLSource());
        this.ocspSource.add(timestampToken.getOCSPSource());
    }
}

