/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlRFC;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlVTS;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.SubContext;
import eu.europa.esig.dss.policy.ValidationPolicy;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.Chain;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.CertificateAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.sav.RevocationAcceptanceValidation;
import eu.europa.esig.dss.validation.process.bbb.xcv.rfc.RevocationFreshnessChecker;
import eu.europa.esig.dss.validation.process.vpfswatsp.POEExtraction;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks.POEExistsAtOrBeforeControlTimeCheck;
import eu.europa.esig.dss.validation.process.vpfswatsp.checks.vts.checks.SatisfyingRevocationDataExistsCheck;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class ValidationTimeSliding
extends Chain<XmlVTS> {
    private final TokenProxy token;
    private final Date currentTime;
    private final XmlBasicBuildingBlocks bbb;
    private final Context context;
    private final POEExtraction poe;
    private final ValidationPolicy policy;
    private Date controlTime;

    public ValidationTimeSliding(I18nProvider i18nProvider, TokenProxy token, Date currentTime, POEExtraction poe, XmlBasicBuildingBlocks bbb, Context context, ValidationPolicy policy) {
        super(i18nProvider, new XmlVTS());
        this.token = token;
        this.currentTime = currentTime;
        this.bbb = bbb;
        this.context = context;
        this.poe = poe;
        this.policy = policy;
    }

    @Override
    protected MessageTag getTitle() {
        return MessageTag.VALIDATION_TIME_SLIDING;
    }

    @Override
    protected void initChain() {
        this.controlTime = this.currentTime;
        List<CertificateWrapper> certificateChain = this.token.getCertificateChain();
        if (Utils.isCollectionNotEmpty(certificateChain)) {
            certificateChain = this.reduceChainUntilFirstTrustAnchor(certificateChain);
            Collections.reverse(certificateChain);
            ChainItem<XmlVTS> item = null;
            for (CertificateWrapper certificate : certificateChain) {
                XmlSAV revocationSAV;
                if (certificate.isTrusted()) continue;
                CertificateRevocationWrapper latestCompliantRevocation = ValidationProcessUtils.getLatestAcceptableRevocationData(certificate, this.bbb);
                if (item == null) {
                    this.firstItem = this.satisfyingRevocationDataExists(latestCompliantRevocation);
                    item = this.firstItem;
                } else {
                    item = item.setNextItem(this.satisfyingRevocationDataExists(latestCompliantRevocation));
                }
                if (latestCompliantRevocation == null) continue;
                item = item.setNextItem(this.poeExistsAtOrBeforeControlTime(certificate, TimestampedObjectType.CERTIFICATE, this.controlTime));
                item = item.setNextItem(this.poeExistsAtOrBeforeControlTime(latestCompliantRevocation, TimestampedObjectType.REVOCATION, this.controlTime));
                if (latestCompliantRevocation.isRevoked()) {
                    this.controlTime = latestCompliantRevocation.getRevocationDate();
                } else if (!this.isFresh(latestCompliantRevocation, this.controlTime)) {
                    this.controlTime = latestCompliantRevocation.getProductionDate();
                }
                Date cryptoNotAfterDate = null;
                XmlSAV certificateSAV = this.getCertificateCryptographicAcceptanceResult(certificate, this.controlTime);
                if (!this.isValidConclusion(certificateSAV.getConclusion()) && certificateSAV.getCryptographicInfo() != null && certificateSAV.getCryptographicInfo().getNotAfter() != null) {
                    cryptoNotAfterDate = certificateSAV.getCryptographicInfo().getNotAfter();
                }
                if (!this.isValidConclusion((revocationSAV = this.getRevocationCryptographicAcceptanceResult(latestCompliantRevocation, this.controlTime)).getConclusion()) && (revocationSAV.getCryptographicInfo() != null && revocationSAV.getCryptographicInfo().getNotAfter() != null && cryptoNotAfterDate == null || revocationSAV.getCryptographicInfo().getNotAfter().before(cryptoNotAfterDate))) {
                    cryptoNotAfterDate = revocationSAV.getCryptographicInfo().getNotAfter();
                }
                if (cryptoNotAfterDate == null || !cryptoNotAfterDate.before(this.controlTime)) continue;
                this.controlTime = cryptoNotAfterDate;
            }
        }
    }

    @Override
    protected void addAdditionalInfo() {
        ((XmlVTS)this.result).setControlTime(this.controlTime);
    }

    private List<CertificateWrapper> reduceChainUntilFirstTrustAnchor(List<CertificateWrapper> originalCertificateChain) {
        ArrayList<CertificateWrapper> result = new ArrayList<CertificateWrapper>();
        for (CertificateWrapper cert : originalCertificateChain) {
            result.add(cert);
            if (!cert.isTrusted()) continue;
            break;
        }
        return result;
    }

    private boolean isFresh(RevocationWrapper revocationData, Date controlTime) {
        RevocationFreshnessChecker rfc = new RevocationFreshnessChecker(this.i18nProvider, revocationData, controlTime, this.context, SubContext.SIGNING_CERT, this.policy);
        XmlRFC execute = (XmlRFC)rfc.execute();
        return execute != null && execute.getConclusion() != null && Indication.PASSED.equals(execute.getConclusion().getIndication());
    }

    private ChainItem<XmlVTS> satisfyingRevocationDataExists(RevocationWrapper revocationData) {
        return new SatisfyingRevocationDataExistsCheck<XmlVTS>(this.i18nProvider, (XmlVTS)this.result, revocationData, this.getFailLevelConstraint());
    }

    private ChainItem<XmlVTS> poeExistsAtOrBeforeControlTime(TokenProxy token, TimestampedObjectType referenceCategory, Date controlTime) {
        return new POEExistsAtOrBeforeControlTimeCheck(this.i18nProvider, (XmlVTS)this.result, token, referenceCategory, controlTime, this.poe, this.getFailLevelConstraint());
    }

    private XmlSAV getCertificateCryptographicAcceptanceResult(CertificateWrapper certificateWrapper, Date controlTime) {
        CertificateAcceptanceValidation cav = new CertificateAcceptanceValidation(this.i18nProvider, controlTime, certificateWrapper, this.policy);
        return (XmlSAV)cav.execute();
    }

    private XmlSAV getRevocationCryptographicAcceptanceResult(RevocationWrapper revocationWrapper, Date controlTime) {
        RevocationAcceptanceValidation rav = new RevocationAcceptanceValidation(this.i18nProvider, controlTime, revocationWrapper, this.policy);
        return (XmlSAV)rav.execute();
    }
}

