/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks.psv.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlPCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;

public class PastCertificateValidationAcceptableCheck
extends ChainItem<XmlPSV> {
    private final XmlPCV pcv;

    public PastCertificateValidationAcceptableCheck(I18nProvider i18nProvider, XmlPSV result, XmlPCV pcv, String tokenId, LevelConstraint constraint) {
        super(i18nProvider, result, constraint, tokenId);
        this.pcv = pcv;
    }

    @Override
    protected boolean process() {
        if (this.pcv != null && this.pcv.getConclusion() != null) {
            Indication pcvIndication = this.pcv.getConclusion().getIndication();
            SubIndication pcvSubindication = this.pcv.getConclusion().getSubIndication();
            return Indication.PASSED.equals(pcvIndication) || Indication.INDETERMINATE.equals(pcvIndication) && (SubIndication.REVOKED_NO_POE.equals(pcvSubindication) || SubIndication.REVOKED_CA_NO_POE.equals(pcvSubindication) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals(pcvSubindication) || SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals(pcvSubindication));
        }
        return false;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.PSV_IPCVA;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.PSV_IPCVA_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.pcv.getConclusion().getIndication();
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.pcv.getConclusion().getSubIndication();
    }
}

