/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.vpfswatsp.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlPSV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSAV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessArchivalData;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;

public class PastTimestampValidation
extends ChainItem<XmlValidationProcessArchivalData> {
    private XmlPSV xmlPSV;
    private XmlSAV xmlSAV;
    private Indication indication;
    private SubIndication subIndication;
    private static final String PSV_BLOCK_SUFFIX = "-PSV";

    public PastTimestampValidation(I18nProvider i18nProvider, XmlValidationProcessArchivalData result, XmlPSV xmlPSV, XmlSAV xmlSAV, TimestampWrapper timestamp, LevelConstraint constraint) {
        super(i18nProvider, result, constraint, timestamp.getId() + PSV_BLOCK_SUFFIX);
        this.xmlPSV = xmlPSV;
        this.xmlSAV = xmlSAV;
    }

    @Override
    protected boolean process() {
        if (!this.isValid(this.xmlPSV)) {
            this.indication = this.xmlPSV.getConclusion().getIndication();
            this.subIndication = this.xmlPSV.getConclusion().getSubIndication();
            return false;
        }
        if (!this.isValid(this.xmlSAV)) {
            this.indication = this.xmlSAV.getConclusion().getIndication();
            this.subIndication = this.xmlSAV.getConclusion().getSubIndication();
            return false;
        }
        return true;
    }

    @Override
    protected MessageTag getMessageTag() {
        return MessageTag.PSV_IPTVC;
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        return MessageTag.PSV_IPTVC_ANS;
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return this.indication;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return this.subIndication;
    }
}

