/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.qualification.certificate.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.ValidationTime;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.LevelConstraint;
import eu.europa.esig.dss.validation.process.ChainItem;
import eu.europa.esig.dss.validation.process.qualification.certificate.QualifiedStatus;

public class QualifiedCheck
extends ChainItem<XmlValidationCertificateQualification> {
    private final QualifiedStatus qualifiedStatus;
    private final ValidationTime validationTime;

    public QualifiedCheck(I18nProvider i18nProvider, XmlValidationCertificateQualification result, QualifiedStatus qualifiedStatus, ValidationTime validationTime, LevelConstraint constraint) {
        super(i18nProvider, result, constraint);
        this.qualifiedStatus = qualifiedStatus;
        this.validationTime = validationTime;
    }

    @Override
    protected boolean process() {
        return QualifiedStatus.isQC(this.qualifiedStatus);
    }

    @Override
    protected MessageTag getMessageTag() {
        switch (this.validationTime) {
            case BEST_SIGNATURE_TIME: {
                return MessageTag.QUAL_QC_AT_ST;
            }
            case CERTIFICATE_ISSUANCE_TIME: {
                return MessageTag.QUAL_QC_AT_CC;
            }
            case VALIDATION_TIME: {
                return MessageTag.QUAL_QC_AT_VT;
            }
        }
        throw new IllegalArgumentException("Unsupported time " + (Object)((Object)this.validationTime));
    }

    @Override
    protected MessageTag getErrorMessageTag() {
        switch (this.validationTime) {
            case BEST_SIGNATURE_TIME: {
                return MessageTag.QUAL_QC_AT_ST_ANS;
            }
            case CERTIFICATE_ISSUANCE_TIME: {
                return MessageTag.QUAL_QC_AT_CC_ANS;
            }
            case VALIDATION_TIME: {
                return MessageTag.QUAL_QC_AT_VT_ANS;
            }
        }
        throw new IllegalArgumentException("Unsupported time " + (Object)((Object)this.validationTime));
    }

    @Override
    protected Indication getFailedIndicationForConclusion() {
        return Indication.FAILED;
    }

    @Override
    protected SubIndication getFailedSubIndicationForConclusion() {
        return null;
    }
}

