/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.policy.jaxb.Algo;
import eu.europa.esig.dss.policy.jaxb.AlgoExpirationDate;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.policy.jaxb.ListAlgo;
import eu.europa.esig.dss.utils.Utils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptographicConstraintWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(CryptographicConstraintWrapper.class);
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private final CryptographicConstraint constraint;

    public CryptographicConstraintWrapper(CryptographicConstraint constraint) {
        this.constraint = constraint;
    }

    public List<String> getSupportedEncryptionAlgorithms() {
        return this.extract(this.constraint.getAcceptableEncryptionAlgo());
    }

    public List<String> getSupportedDigestAlgorithms() {
        return this.extract(this.constraint.getAcceptableDigestAlgo());
    }

    public Map<String, Integer> getMinimumKeySizes() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        ListAlgo miniPublicKeySize = this.constraint.getMiniPublicKeySize();
        if (miniPublicKeySize != null && Utils.isCollectionNotEmpty(miniPublicKeySize.getAlgo())) {
            for (Algo algo : miniPublicKeySize.getAlgo()) {
                Integer size = algo.getSize();
                if (size != null) {
                    result.put(algo.getValue(), size);
                    continue;
                }
                result.put(algo.getValue(), 0);
            }
        }
        return result;
    }

    public Date getExpirationDate(String algoToSearch, Integer keyLength) {
        TreeMap<Integer, Date> dates = new TreeMap<Integer, Date>();
        AlgoExpirationDate expirations = this.constraint.getAlgoExpirationDate();
        if (expirations == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(Utils.isStringEmpty(expirations.getFormat()) ? DEFAULT_DATE_FORMAT : expirations.getFormat());
        for (Algo algo : expirations.getAlgo()) {
            if (!algo.getValue().equals(algoToSearch)) continue;
            String expirationDate = algo.getDate();
            try {
                dates.put(algo.getSize(), dateFormat.parse(expirationDate));
            }
            catch (ParseException e) {
                LOG.warn("Unable to parse '{}' with format '{}'", (Object)expirationDate, (Object)dateFormat);
            }
        }
        Map.Entry floorEntry = dates.floorEntry(keyLength);
        if (floorEntry == null) {
            return null;
        }
        return (Date)floorEntry.getValue();
    }

    public Date getDigestAlgorithmExpirationDate(String digestAlgoToSearch) {
        AlgoExpirationDate expirations = this.constraint.getAlgoExpirationDate();
        if (expirations == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(Utils.isStringEmpty(expirations.getFormat()) ? DEFAULT_DATE_FORMAT : expirations.getFormat());
        for (Algo algo : expirations.getAlgo()) {
            if (!algo.getValue().equals(digestAlgoToSearch)) continue;
            String expirationDate = algo.getDate();
            try {
                return dateFormat.parse(expirationDate);
            }
            catch (ParseException e) {
                LOG.warn("Unable to parse '{}' with format '{}'", (Object)expirationDate, (Object)dateFormat);
            }
        }
        return null;
    }

    public Map<String, Date> getExpirationTimes() {
        HashMap<String, Date> result = new HashMap<String, Date>();
        AlgoExpirationDate expirations = this.constraint.getAlgoExpirationDate();
        if (expirations != null && Utils.isCollectionNotEmpty(expirations.getAlgo())) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(Utils.isStringEmpty(expirations.getFormat()) ? DEFAULT_DATE_FORMAT : expirations.getFormat());
            for (Algo algo : expirations.getAlgo()) {
                String currentAlgo = algo.getValue();
                String expirationDate = algo.getDate();
                try {
                    result.put(currentAlgo, dateFormat.parse(expirationDate));
                }
                catch (ParseException e) {
                    LOG.warn("Unable to parse '{}' with format '{}'", (Object)expirationDate, (Object)dateFormat);
                }
            }
        }
        return result;
    }

    private List<String> extract(ListAlgo listAlgo) {
        ArrayList<String> result = new ArrayList<String>();
        if (listAlgo != null && Utils.isCollectionNotEmpty(listAlgo.getAlgo())) {
            for (Algo algo : listAlgo.getAlgo()) {
                result.add(algo.getValue());
            }
        }
        return result;
    }
}

