/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process.bbb.sav.checks;

import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.TokenProxy;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import eu.europa.esig.dss.policy.jaxb.CryptographicConstraint;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.process.ValidationProcessUtils;
import eu.europa.esig.dss.validation.process.bbb.sav.checks.AbstractCryptographicCheck;
import java.util.Date;

public class CryptographicCheck<T extends XmlConstraintsConclusion>
extends AbstractCryptographicCheck<T> {
    private final TokenProxy token;
    private final CryptographicConstraint constraint;

    public CryptographicCheck(I18nProvider i18nProvider, T result, TokenProxy token, Date currentTime, CryptographicConstraint constraint) {
        super(i18nProvider, result, currentTime, constraint);
        this.constraint = constraint;
        this.token = token;
    }

    @Override
    protected boolean process() {
        boolean expirationCheckRequired = this.isExpirationDateAvailable(this.constraint);
        if (!this.encryptionAlgorithmIsReliable(this.token.getEncryptionAlgorithm())) {
            return false;
        }
        if (!this.digestAlgorithmIsReliable(this.token.getDigestAlgorithm())) {
            return false;
        }
        if (expirationCheckRequired && !this.digestAlgorithmIsValidOnValidationDate(this.token.getDigestAlgorithm())) {
            return false;
        }
        if (!this.isPublicKeySizeKnown(this.token.getKeyLengthUsedToSignThisToken())) {
            return false;
        }
        if (!this.publicKeySizeIsAcceptable(this.token.getEncryptionAlgorithm(), this.token.getKeyLengthUsedToSignThisToken())) {
            return false;
        }
        return !expirationCheckRequired || this.encryptionAlgorithmIsValidOnValidationDate(this.token.getEncryptionAlgorithm(), this.token.getKeyLengthUsedToSignThisToken());
    }

    @Override
    protected MessageTag getMessageTag() {
        if (this.token instanceof CertificateWrapper) {
            return MessageTag.ACCCM;
        }
        if (this.token instanceof RevocationWrapper) {
            return MessageTag.ARCCM;
        }
        if (this.token instanceof TimestampWrapper) {
            return MessageTag.ATCCM;
        }
        return super.getMessageTag();
    }

    @Override
    protected MessageTag getAdditionalInfo() {
        String dateTime = ValidationProcessUtils.getFormattedDate(this.validationDate);
        if (Utils.isStringNotEmpty(this.failedAlgorithm)) {
            return MessageTag.CRYPTOGRAPHIC_CHECK_FAILURE_WITH_ID.setArgs(this.failedAlgorithm, dateTime, this.token.getId());
        }
        return MessageTag.VALIDATION_TIME_WITH_ID.setArgs(dateTime, this.token.getId());
    }
}

