/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation.process;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.i18n.I18nProvider;
import eu.europa.esig.dss.i18n.MessageTag;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class ValidationProcessUtils {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm";

    public static boolean isRevocationCheckRequired(CertificateWrapper certificate, Date controlTime) {
        if (certificate.isIdPkixOcspNoCheck()) {
            return controlTime.compareTo(certificate.getNotBefore()) < 0 || controlTime.compareTo(certificate.getNotAfter()) > 0;
        }
        return true;
    }

    public static boolean isAllowedBasicSignatureValidation(XmlConclusion conclusion) {
        return Indication.PASSED.equals(conclusion.getIndication()) || Indication.INDETERMINATE.equals(conclusion.getIndication()) && (SubIndication.CRYPTO_CONSTRAINTS_FAILURE_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.REVOKED_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.REVOKED_CA_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.TRY_LATER.equals(conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NO_POE.equals(conclusion.getSubIndication()) || SubIndication.OUT_OF_BOUNDS_NOT_REVOKED.equals(conclusion.getSubIndication()));
    }

    public static CertificateRevocationWrapper getLatestAcceptableRevocationData(CertificateWrapper certificate, XmlBasicBuildingBlocks bbb) {
        if (bbb != null && bbb.getXCV() != null) {
            for (XmlSubXCV subXCV : bbb.getXCV().getSubXCV()) {
                if (!certificate.getId().equals(subXCV.getId()) || subXCV.getRFC() == null) continue;
                return certificate.getRevocationDataById(subXCV.getRFC().getId());
            }
        }
        return null;
    }

    public static String getFormattedDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }

    public static String buildStringMessage(I18nProvider i18nProvider, MessageTag messageTag) {
        if (messageTag != null) {
            return i18nProvider.getMessage(messageTag);
        }
        return null;
    }
}

