/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.Revocation;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public interface ValidationContext {
    public void setCurrentTime(Date var1);

    public void initialize(CertificateVerifier var1);

    public Date getCurrentTime();

    public void addRevocationTokenForVerification(RevocationToken<Revocation> var1);

    public void addCertificateTokenForVerification(CertificateToken var1);

    public void addTimestampTokenForVerification(TimestampToken var1);

    public void validate();

    public boolean checkAllRequiredRevocationDataPresent();

    public boolean checkAllPOECoveredByRevocationData();

    public boolean checkAllTimestampsValid();

    public boolean checkAllCertificatesValid();

    public boolean checkAtLeastOneRevocationDataPresentAfterBestSignatureTime(CertificateToken var1);

    public Set<CertificateToken> getProcessedCertificates();

    public Map<CertificateToken, Set<CertificateSourceType>> getCertificateSourceTypes();

    public Set<RevocationToken<Revocation>> getProcessedRevocations();

    public Set<TimestampToken> getProcessedTimestamps();
}

