/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl.job;

import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.tsl.OtherTSLPointer;
import eu.europa.esig.dss.spi.x509.CertificateSource;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import eu.europa.esig.dss.tsl.cache.CacheKey;
import eu.europa.esig.dss.tsl.dto.ParsingCacheDTO;
import eu.europa.esig.dss.tsl.source.LOTLSource;
import eu.europa.esig.dss.tsl.source.TLSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TLSourceBuilder {
    private final List<LOTLSource> lotlList;
    private final Map<CacheKey, ParsingCacheDTO> parsingResults;

    public TLSourceBuilder(List<LOTLSource> lotlList, Map<CacheKey, ParsingCacheDTO> parsingResults) {
        this.lotlList = lotlList;
        this.parsingResults = parsingResults;
    }

    public List<TLSource> build() {
        ArrayList<TLSource> result = new ArrayList<TLSource>();
        if (this.lotlList != null) {
            for (LOTLSource lotlSource : this.lotlList) {
                ParsingCacheDTO cachedResult = this.parsingResults.get(lotlSource.getCacheKey());
                if (cachedResult == null || !cachedResult.isResultExist()) continue;
                List<OtherTSLPointer> tlPointers = cachedResult.getTlOtherPointers();
                for (OtherTSLPointer otherTSLPointerDTO : tlPointers) {
                    result.add(this.getTLSource(otherTSLPointerDTO, lotlSource));
                }
            }
        }
        return result;
    }

    private TLSource getTLSource(OtherTSLPointer otherTSLPointerDTO, LOTLSource lotlSource) {
        TLSource tlSource = new TLSource();
        tlSource.setUrl(otherTSLPointerDTO.getLocation());
        tlSource.setCertificateSource(this.getCertificateSource(otherTSLPointerDTO.getCertificates()));
        tlSource.setTrustServiceProviderPredicate(lotlSource.getTrustServiceProviderPredicate());
        tlSource.setTrustServicePredicate(lotlSource.getTrustServicePredicate());
        return tlSource;
    }

    private CertificateSource getCertificateSource(List<CertificateToken> certificates) {
        CommonCertificateSource certificateSource = new CommonCertificateSource();
        for (CertificateToken certificate : certificates) {
            certificateSource.addCertificate(certificate);
        }
        return certificateSource;
    }
}

