/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.spi.x509;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreCertificateSource
extends CommonCertificateSource {
    private static final Logger LOG = LoggerFactory.getLogger(KeyStoreCertificateSource.class);
    private KeyStore keyStore;
    private KeyStore.PasswordProtection passwordProtection;

    public KeyStoreCertificateSource(String ksType, String ksPassword) {
        this((InputStream)null, ksType, ksPassword);
    }

    public KeyStoreCertificateSource(String ksFilePath, String ksType, String ksPassword) throws IOException {
        this(new File(ksFilePath), ksType, ksPassword);
    }

    public KeyStoreCertificateSource(File ksFile, String ksType, String ksPassword) throws IOException {
        this(new FileInputStream(ksFile), ksType, ksPassword);
    }

    public KeyStoreCertificateSource(InputStream ksStream, String ksType, String ksPassword) {
        this.initKeystore(ksStream, ksType, ksPassword);
    }

    private void initKeystore(InputStream ksStream, String ksType, String ksPassword) {
        try (InputStream is = ksStream;){
            this.keyStore = KeyStore.getInstance(ksType);
            char[] password = ksPassword == null ? null : ksPassword.toCharArray();
            this.keyStore.load(is, password);
            this.passwordProtection = new KeyStore.PasswordProtection(password);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new DSSException("Unable to initialize the keystore", e);
        }
    }

    public CertificateToken getCertificate(String alias) {
        try {
            String aliasToSearch = this.getKey(alias);
            if (this.keyStore.containsAlias(aliasToSearch)) {
                Certificate certificate = this.keyStore.getCertificate(aliasToSearch);
                return DSSUtils.loadCertificate(certificate.getEncoded());
            }
            LOG.warn("Certificate '{}' not found in the keystore", (Object)aliasToSearch);
            return null;
        }
        catch (GeneralSecurityException e) {
            throw new DSSException("Unable to retrieve certificate from the keystore", e);
        }
    }

    @Override
    public List<CertificateToken> getCertificates() {
        ArrayList<CertificateToken> list = new ArrayList<CertificateToken>();
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate certificate = this.keyStore.getCertificate(this.getKey(aliases.nextElement()));
                list.add(DSSUtils.loadCertificate(certificate.getEncoded()));
            }
        }
        catch (GeneralSecurityException e) {
            throw new DSSException("Unable to retrieve certificates from the keystore", e);
        }
        return Collections.unmodifiableList(list);
    }

    public void addAllCertificatesToKeyStore(List<CertificateToken> certificates) {
        for (CertificateToken certificateToken : certificates) {
            this.addCertificateToKeyStore(certificateToken);
        }
    }

    public void addCertificateToKeyStore(CertificateToken certificateToken) {
        try {
            this.keyStore.setCertificateEntry(this.getKey(certificateToken.getDSSIdAsString()), certificateToken.getCertificate());
        }
        catch (GeneralSecurityException e) {
            throw new DSSException("Unable to add certificate to the keystore", e);
        }
    }

    public void deleteCertificateFromKeyStore(String alias) {
        try {
            if (this.keyStore.containsAlias(alias)) {
                this.keyStore.deleteEntry(alias);
                LOG.info("Certificate '{}' successfuly removed from the keystore", (Object)alias);
            } else {
                LOG.warn("Certificate '{}' not found in the keystore", (Object)alias);
            }
        }
        catch (GeneralSecurityException e) {
            throw new DSSException("Unable to delete certificate from the keystore", e);
        }
    }

    public void clearAllCertificates() {
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                this.deleteCertificateFromKeyStore(alias);
            }
        }
        catch (GeneralSecurityException e) {
            throw new DSSException("Unable to clear certificates from the keystore", e);
        }
    }

    public void store(OutputStream os) {
        try {
            this.keyStore.store(os, this.passwordProtection.getPassword());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new DSSException("Unable to store the keystore", e);
        }
    }

    private String getKey(String inputKey) {
        if ("PKCS12".equals(this.keyStore.getType())) {
            return inputKey.toLowerCase(Locale.ROOT);
        }
        return inputKey;
    }
}

