/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer;

import eu.europa.esig.dss.enumerations.VisualSignatureAlignmentHorizontal;
import eu.europa.esig.dss.enumerations.VisualSignatureAlignmentVertical;
import eu.europa.esig.dss.pades.SignatureImageParameters;
import eu.europa.esig.dss.pdf.pdfbox.visible.ImageRotationUtils;
import eu.europa.esig.dss.pdf.pdfbox.visible.defaultdrawer.SignatureImageAndPosition;
import eu.europa.esig.dss.pdf.visible.ImageAndResolution;
import eu.europa.esig.dss.pdf.visible.ImageUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

public final class SignatureImageAndPositionProcessor {
    private static final String NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE = "not supported vertical alignment: ";
    private static final String NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE = "not supported horizontal alignment: ";

    private SignatureImageAndPositionProcessor() {
    }

    public static SignatureImageAndPosition process(SignatureImageParameters signatureImageParameters, PDDocument doc, ImageAndResolution ires) throws IOException {
        try (InputStream is = ires.getInputStream();){
            BufferedImage visualImageSignature = ImageUtils.read(is);
            PDPage pdPage = doc.getPages().get(signatureImageParameters.getPage() - 1);
            int rotate = ImageRotationUtils.getRotation(signatureImageParameters.getRotation(), pdPage);
            if (rotate != 360) {
                visualImageSignature = ImageUtils.rotate(visualImageSignature, rotate);
            }
            float x = SignatureImageAndPositionProcessor.processX(rotate, ires, visualImageSignature, pdPage, signatureImageParameters);
            float y = SignatureImageAndPositionProcessor.processY(rotate, ires, visualImageSignature, pdPage, signatureImageParameters);
            ByteArrayOutputStream visualImageSignatureOutputStream = new ByteArrayOutputStream();
            String imageType = "jpg";
            if (visualImageSignature.getColorModel().hasAlpha()) {
                imageType = "png";
            }
            ImageIO.write((RenderedImage)visualImageSignature, imageType, visualImageSignatureOutputStream);
            SignatureImageAndPosition signatureImageAndPosition = new SignatureImageAndPosition(x, y, visualImageSignatureOutputStream.toByteArray(), rotate);
            return signatureImageAndPosition;
        }
    }

    private static float processX(int rotation, ImageAndResolution ires, BufferedImage visualImageSignature, PDPage pdPage, SignatureImageParameters signatureImageParameters) {
        float x;
        PDRectangle pageBox = pdPage.getMediaBox();
        float width = SignatureImageAndPositionProcessor.getWidth(signatureImageParameters, visualImageSignature, ires, ImageRotationUtils.isSwapOfDimensionsRequired(rotation));
        switch (rotation) {
            case 90: {
                x = SignatureImageAndPositionProcessor.processXAngle90(pageBox, signatureImageParameters, width);
                break;
            }
            case 180: {
                x = SignatureImageAndPositionProcessor.processXAngle180(pageBox, signatureImageParameters, width);
                break;
            }
            case 270: {
                x = SignatureImageAndPositionProcessor.processXAngle270(pageBox, signatureImageParameters, width);
                break;
            }
            case 360: {
                x = SignatureImageAndPositionProcessor.processXAngle360(pageBox, signatureImageParameters, width);
                break;
            }
            default: {
                throw new IllegalStateException("rotation angle must be 90, 180, 270 or 360 (0)");
            }
        }
        return x;
    }

    private static float processY(int rotation, ImageAndResolution ires, BufferedImage visualImageSignature, PDPage pdPage, SignatureImageParameters signatureImageParameters) {
        float y;
        PDRectangle pageBox = pdPage.getMediaBox();
        float height = SignatureImageAndPositionProcessor.getHeight(signatureImageParameters, visualImageSignature, ires, ImageRotationUtils.isSwapOfDimensionsRequired(rotation));
        switch (rotation) {
            case 90: {
                y = SignatureImageAndPositionProcessor.processYAngle90(pageBox, signatureImageParameters, height);
                break;
            }
            case 180: {
                y = SignatureImageAndPositionProcessor.processYAngle180(pageBox, signatureImageParameters, height);
                break;
            }
            case 270: {
                y = SignatureImageAndPositionProcessor.processYAngle270(pageBox, signatureImageParameters, height);
                break;
            }
            case 360: {
                y = SignatureImageAndPositionProcessor.processYAngle360(pageBox, signatureImageParameters, height);
                break;
            }
            default: {
                throw new IllegalStateException("rotation angle must be 90, 180, 270 or 360 (0)");
            }
        }
        return y;
    }

    private static float getWidth(SignatureImageParameters signatureImageParameters, BufferedImage visualImageSignature, ImageAndResolution ires, boolean swapDimensions) {
        float width;
        float f = width = swapDimensions ? (float)signatureImageParameters.getHeight() : (float)signatureImageParameters.getWidth();
        if (width == 0.0f) {
            width = visualImageSignature.getWidth();
            width = swapDimensions ? ires.toYPoint(width) : ires.toXPoint(width);
        }
        return width;
    }

    private static float getHeight(SignatureImageParameters signatureImageParameters, BufferedImage visualImageSignature, ImageAndResolution ires, boolean swapDimensions) {
        float height;
        float f = height = swapDimensions ? (float)signatureImageParameters.getWidth() : (float)signatureImageParameters.getHeight();
        if (height == 0.0f) {
            height = visualImageSignature.getHeight();
            height = swapDimensions ? ires.toXPoint(height) : ires.toYPoint(height);
        }
        return height;
    }

    private static float processXAngle90(PDRectangle mediaBox, SignatureImageParameters signatureImageParameters, float width) {
        float x;
        VisualSignatureAlignmentVertical alignmentVertical = signatureImageParameters.getVisualSignatureAlignmentVertical();
        switch (alignmentVertical) {
            case TOP: 
            case NONE: {
                x = mediaBox.getWidth() - SignatureImageAndPositionProcessor.zoom(width, signatureImageParameters.getZoom()) - signatureImageParameters.getyAxis();
                break;
            }
            case MIDDLE: {
                x = (mediaBox.getWidth() - SignatureImageAndPositionProcessor.zoom(width, signatureImageParameters.getZoom())) / 2.0f;
                break;
            }
            case BOTTOM: {
                x = signatureImageParameters.getyAxis();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE + alignmentVertical.name());
            }
        }
        return x;
    }

    private static float processXAngle180(PDRectangle mediaBox, SignatureImageParameters signatureImageParameters, float width) {
        float x;
        VisualSignatureAlignmentHorizontal alignmentHorizontal = signatureImageParameters.getVisualSignatureAlignmentHorizontal();
        switch (alignmentHorizontal) {
            case LEFT: 
            case NONE: {
                x = mediaBox.getWidth() - SignatureImageAndPositionProcessor.zoom(width, signatureImageParameters.getZoom()) - signatureImageParameters.getxAxis();
                break;
            }
            case CENTER: {
                x = (mediaBox.getWidth() - SignatureImageAndPositionProcessor.zoom(width, signatureImageParameters.getZoom())) / 2.0f;
                break;
            }
            case RIGHT: {
                x = signatureImageParameters.getxAxis();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE + alignmentHorizontal.name());
            }
        }
        return x;
    }

    private static float processXAngle270(PDRectangle mediaBox, SignatureImageParameters signatureImageParameters, float width) {
        float x;
        VisualSignatureAlignmentVertical alignmentVertical = signatureImageParameters.getVisualSignatureAlignmentVertical();
        switch (alignmentVertical) {
            case TOP: 
            case NONE: {
                x = signatureImageParameters.getyAxis();
                break;
            }
            case MIDDLE: {
                x = (mediaBox.getWidth() - SignatureImageAndPositionProcessor.zoom(width, signatureImageParameters.getZoom())) / 2.0f;
                break;
            }
            case BOTTOM: {
                x = mediaBox.getWidth() - SignatureImageAndPositionProcessor.zoom(width, signatureImageParameters.getZoom()) - signatureImageParameters.getyAxis();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE + alignmentVertical.name());
            }
        }
        return x;
    }

    private static float processXAngle360(PDRectangle mediaBox, SignatureImageParameters signatureImageParameters, float width) {
        float x;
        VisualSignatureAlignmentHorizontal alignmentHorizontal = signatureImageParameters.getVisualSignatureAlignmentHorizontal();
        switch (alignmentHorizontal) {
            case LEFT: 
            case NONE: {
                x = signatureImageParameters.getxAxis();
                break;
            }
            case CENTER: {
                x = (mediaBox.getWidth() - SignatureImageAndPositionProcessor.zoom(width, signatureImageParameters.getZoom())) / 2.0f;
                break;
            }
            case RIGHT: {
                x = mediaBox.getWidth() - SignatureImageAndPositionProcessor.zoom(width, signatureImageParameters.getZoom()) - signatureImageParameters.getxAxis();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE + alignmentHorizontal.name());
            }
        }
        return x;
    }

    private static float processYAngle90(PDRectangle mediaBox, SignatureImageParameters signatureImageParameters, float height) {
        float y;
        VisualSignatureAlignmentHorizontal alignmentHorizontal = signatureImageParameters.getVisualSignatureAlignmentHorizontal();
        switch (alignmentHorizontal) {
            case LEFT: 
            case NONE: {
                y = signatureImageParameters.getxAxis();
                break;
            }
            case CENTER: {
                y = (mediaBox.getHeight() - SignatureImageAndPositionProcessor.zoom(height, signatureImageParameters.getZoom())) / 2.0f;
                break;
            }
            case RIGHT: {
                y = mediaBox.getHeight() - SignatureImageAndPositionProcessor.zoom(height, signatureImageParameters.getZoom()) - signatureImageParameters.getxAxis();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE + alignmentHorizontal.name());
            }
        }
        return y;
    }

    private static float processYAngle180(PDRectangle mediaBox, SignatureImageParameters signatureImageParameters, float height) {
        float y;
        VisualSignatureAlignmentVertical alignmentVertical = signatureImageParameters.getVisualSignatureAlignmentVertical();
        switch (alignmentVertical) {
            case TOP: 
            case NONE: {
                y = mediaBox.getHeight() - SignatureImageAndPositionProcessor.zoom(height, signatureImageParameters.getZoom()) - signatureImageParameters.getyAxis();
                break;
            }
            case MIDDLE: {
                y = (mediaBox.getHeight() - SignatureImageAndPositionProcessor.zoom(height, signatureImageParameters.getZoom())) / 2.0f;
                break;
            }
            case BOTTOM: {
                y = signatureImageParameters.getyAxis();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE + alignmentVertical.name());
            }
        }
        return y;
    }

    private static float processYAngle270(PDRectangle mediaBox, SignatureImageParameters signatureImageParameters, float height) {
        float y;
        VisualSignatureAlignmentHorizontal alignmentHorizontal = signatureImageParameters.getVisualSignatureAlignmentHorizontal();
        switch (alignmentHorizontal) {
            case LEFT: 
            case NONE: {
                y = mediaBox.getHeight() - SignatureImageAndPositionProcessor.zoom(height, signatureImageParameters.getZoom()) - signatureImageParameters.getxAxis();
                break;
            }
            case CENTER: {
                y = (mediaBox.getHeight() - SignatureImageAndPositionProcessor.zoom(height, signatureImageParameters.getZoom())) / 2.0f;
                break;
            }
            case RIGHT: {
                y = signatureImageParameters.getxAxis();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_HORIZONTAL_ALIGNMENT_ERROR_MESSAGE + alignmentHorizontal.name());
            }
        }
        return y;
    }

    private static float processYAngle360(PDRectangle mediaBox, SignatureImageParameters signatureImageParameters, float height) {
        float y;
        VisualSignatureAlignmentVertical alignmentVertical = signatureImageParameters.getVisualSignatureAlignmentVertical();
        switch (alignmentVertical) {
            case TOP: 
            case NONE: {
                y = signatureImageParameters.getyAxis();
                break;
            }
            case MIDDLE: {
                y = (mediaBox.getHeight() - SignatureImageAndPositionProcessor.zoom(height, signatureImageParameters.getZoom())) / 2.0f;
                break;
            }
            case BOTTOM: {
                y = mediaBox.getHeight() - SignatureImageAndPositionProcessor.zoom(height, signatureImageParameters.getZoom()) - signatureImageParameters.getyAxis();
                break;
            }
            default: {
                throw new IllegalStateException(NOT_SUPPORTED_VERTICAL_ALIGNMENT_ERROR_MESSAGE + alignmentVertical.name());
            }
        }
        return y;
    }

    private static float zoom(float originalFloat, int zoom) {
        return originalFloat * (float)zoom / 100.0f;
    }
}

