/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import eu.europa.esig.dss.enumerations.SignatureForm;

public enum SignatureLevel {
    XML_NOT_ETSI,
    XAdES_C,
    XAdES_X,
    XAdES_XL,
    XAdES_A,
    XAdES_BASELINE_LTA,
    XAdES_BASELINE_LT,
    XAdES_BASELINE_T,
    XAdES_BASELINE_B,
    CMS_NOT_ETSI,
    CAdES_BASELINE_LTA,
    CAdES_BASELINE_LT,
    CAdES_BASELINE_T,
    CAdES_BASELINE_B,
    CAdES_101733_C,
    CAdES_101733_X,
    CAdES_101733_A,
    PDF_NOT_ETSI,
    PAdES_BASELINE_LTA,
    PAdES_BASELINE_LT,
    PAdES_BASELINE_T,
    PAdES_BASELINE_B,
    PKCS7_B,
    PKCS7_T,
    PKCS7_LT,
    PKCS7_LTA,
    UNKNOWN;


    public static SignatureLevel valueByName(String name) {
        return SignatureLevel.valueOf(name.replace('-', '_'));
    }

    public String toString() {
        return super.toString().replace('_', '-');
    }

    public SignatureForm getSignatureForm() {
        switch (this) {
            case XML_NOT_ETSI: 
            case XAdES_C: 
            case XAdES_X: 
            case XAdES_XL: 
            case XAdES_A: 
            case XAdES_BASELINE_LTA: 
            case XAdES_BASELINE_LT: 
            case XAdES_BASELINE_T: 
            case XAdES_BASELINE_B: {
                return SignatureForm.XAdES;
            }
            case CMS_NOT_ETSI: 
            case CAdES_BASELINE_LTA: 
            case CAdES_BASELINE_LT: 
            case CAdES_BASELINE_T: 
            case CAdES_BASELINE_B: 
            case CAdES_101733_A: 
            case CAdES_101733_C: 
            case CAdES_101733_X: {
                return SignatureForm.CAdES;
            }
            case PDF_NOT_ETSI: 
            case PAdES_BASELINE_B: 
            case PAdES_BASELINE_T: 
            case PAdES_BASELINE_LT: 
            case PAdES_BASELINE_LTA: {
                return SignatureForm.PAdES;
            }
            case PKCS7_B: 
            case PKCS7_T: 
            case PKCS7_LT: 
            case PKCS7_LTA: {
                return SignatureForm.PKCS7;
            }
        }
        return null;
    }
}

