/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.AbstractTokenProxy;
import eu.europa.esig.dss.diagnostic.FoundCertificatesProxy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlBasicSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlChainItem;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSigningCertificate;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationType;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class RevocationWrapper
extends AbstractTokenProxy {
    private final XmlRevocation revocation;

    public RevocationWrapper(XmlRevocation revocation) {
        Objects.requireNonNull(revocation, "XMLRevocation cannot be null!");
        this.revocation = revocation;
    }

    @Override
    public String getId() {
        return this.revocation.getId();
    }

    @Override
    protected XmlBasicSignature getCurrentBasicSignature() {
        return this.revocation.getBasicSignature();
    }

    @Override
    protected List<XmlChainItem> getCurrentCertificateChain() {
        return this.revocation.getCertificateChain();
    }

    @Override
    protected XmlSigningCertificate getCurrentSigningCertificate() {
        return this.revocation.getSigningCertificate();
    }

    @Override
    public FoundCertificatesProxy foundCertificates() {
        return new FoundCertificatesProxy(this.revocation.getFoundCertificates());
    }

    public Date getProductionDate() {
        return this.revocation.getProductionDate();
    }

    public Date getThisUpdate() {
        return this.revocation.getThisUpdate();
    }

    public Date getNextUpdate() {
        return this.revocation.getNextUpdate();
    }

    public Date getExpiredCertsOnCRL() {
        return this.revocation.getExpiredCertsOnCRL();
    }

    public Date getArchiveCutOff() {
        return this.revocation.getArchiveCutOff();
    }

    public boolean isCertHashExtensionPresent() {
        return this.revocation.isCertHashExtensionPresent() != null && this.revocation.isCertHashExtensionPresent() != false;
    }

    public boolean isCertHashExtensionMatch() {
        return this.revocation.isCertHashExtensionMatch() != null && this.revocation.isCertHashExtensionMatch() != false;
    }

    public RevocationOrigin getOrigin() {
        return this.revocation.getOrigin();
    }

    public RevocationType getRevocationType() {
        return this.revocation.getType();
    }

    @Override
    public byte[] getBinaries() {
        return this.revocation.getBase64Encoded();
    }

    public XmlDigestAlgoAndValue getDigestAlgoAndValue() {
        return this.revocation.getDigestAlgoAndValue();
    }

    public boolean isInternalRevocationOrigin() {
        RevocationOrigin originType = this.getOrigin();
        if (originType != null) {
            return this.getOrigin().isInternalOrigin();
        }
        return false;
    }

    public String getSourceAddress() {
        return this.revocation.getSourceAddress();
    }
}

