/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;

public class SignedAssertion
extends ASN1Object {
    private final ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier("0.4.0.19122.1.6");
    private DERPrintableString assertion;

    public static SignedAssertion getInstance(Object obj) {
        if (obj instanceof SignedAssertion) {
            return (SignedAssertion)obj;
        }
        if (obj != null) {
            return new SignedAssertion(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public SignedAssertion(String assertion) {
        this.assertion = new DERPrintableString(assertion);
    }

    private SignedAssertion(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.assertion = DERPrintableString.getInstance(seq.getObjectAt(1));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.oid);
        v.add(this.assertion);
        return new DERSequence(v);
    }

    public String toString() {
        return this.assertion.getString();
    }
}

